/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.NettyH2HeadersToHttpHeaders;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

final class H2ToStH1Utils {
    static final CharSequence PROXY_CONNECTION = CharSequences.newAsciiString("proxy-connection");
    static final boolean COOKIE_STRICT_RFC_6265 = Boolean.parseBoolean(System.getProperty("io.servicetalk.http.api.headers.cookieParsingStrictRfc6265", "false"));

    private H2ToStH1Utils() {
    }

    static void h2HeadersSanitizeForH1(Http2Headers h2Headers) {
        H2ToStH1Utils.h2HeadersCompressCookieCrumbs(h2Headers);
    }

    static void h2HeadersCompressCookieCrumbs(Http2Headers h2Headers) {
        Iterator<CharSequence> cookieItr = h2Headers.valueIterator(HttpHeaderNames.COOKIE);
        if (cookieItr.hasNext()) {
            CharSequence prevCookItr = cookieItr.next();
            if (cookieItr.hasNext()) {
                CharSequence cookieHeader = cookieItr.next();
                StringBuilder sb = new StringBuilder(prevCookItr.length() * 2 + cookieHeader.length() + 2);
                sb.append(prevCookItr).append("; ").append(cookieHeader);
                while (cookieItr.hasNext()) {
                    cookieHeader = cookieItr.next();
                    sb.append("; ").append(cookieHeader);
                }
                h2Headers.set(HttpHeaderNames.COOKIE, sb.toString());
            }
        }
    }

    static void h1HeadersSplitCookieCrumbs(HttpHeaders h1Headers) {
        Iterator<? extends CharSequence> cookieItr = h1Headers.valuesIterator(io.servicetalk.http.api.HttpHeaderNames.COOKIE);
        ArrayList<CharSequence> cookiesToAdd = null;
        while (cookieItr.hasNext()) {
            CharSequence nextCookie = cookieItr.next();
            int i = HeaderUtils.indexOf(nextCookie, ';', 0);
            if (i <= 0) continue;
            if (cookiesToAdd == null) {
                cookiesToAdd = new ArrayList<CharSequence>(4);
            }
            int start = 0;
            if (COOKIE_STRICT_RFC_6265) {
                do {
                    CharSequence cookieCrumb = nextCookie.subSequence(start, i);
                    cookiesToAdd.add(cookieCrumb);
                    if (i + 1 < nextCookie.length() && nextCookie.charAt(i + 1) != ' ') {
                        H2ToStH1Utils.throwNoSpaceAfterCookieCrumb(cookieCrumb);
                    }
                    if (nextCookie.length() - 2 > i) continue;
                    H2ToStH1Utils.throwNotAllowedToEndWithSemicolon(cookieCrumb);
                } while ((start = i + 2) >= 0 && start < nextCookie.length() && (i = HeaderUtils.indexOf(nextCookie, ';', start)) >= 0);
            } else {
                do {
                    cookiesToAdd.add(nextCookie.subSequence(start, i));
                    int n = start = i + 1 < nextCookie.length() && nextCookie.charAt(i + 1) == ' ' ? i + 2 : i + 1;
                } while (start >= 0 && start < nextCookie.length() && (i = HeaderUtils.indexOf(nextCookie, ';', start)) >= 0);
            }
            if (start >= 0 && start < nextCookie.length()) {
                cookiesToAdd.add(nextCookie.subSequence(start, nextCookie.length()));
            }
            cookieItr.remove();
        }
        if (cookiesToAdd != null) {
            for (CharSequence crumb : cookiesToAdd) {
                h1Headers.add(io.servicetalk.http.api.HttpHeaderNames.COOKIE, crumb);
            }
        }
    }

    private static void throwNoSpaceAfterCookieCrumb(CharSequence cookieCrumb) {
        int nameEnd = HeaderUtils.indexOf(cookieCrumb, '=', 0);
        CharSequence name = nameEnd > 0 ? cookieCrumb.subSequence(0, nameEnd) : cookieCrumb;
        throw new IllegalArgumentException("cookie " + name + " must have a space after ; in cookie attribute-value lists");
    }

    private static void throwNotAllowedToEndWithSemicolon(CharSequence cookieCrumb) {
        int nameEnd = HeaderUtils.indexOf(cookieCrumb, '=', 0);
        CharSequence name = nameEnd > 0 ? cookieCrumb.subSequence(0, nameEnd) : cookieCrumb;
        throw new IllegalArgumentException("cookie '" + name + "': cookie is not allowed to end with ;");
    }

    static Http2Headers h1HeadersToH2Headers(HttpHeaders h1Headers) {
        if (h1Headers.isEmpty()) {
            if (h1Headers instanceof NettyH2HeadersToHttpHeaders) {
                return ((NettyH2HeadersToHttpHeaders)h1Headers).nettyHeaders();
            }
            return new DefaultHttp2Headers(false, 0);
        }
        Iterator<? extends CharSequence> connectionItr = h1Headers.valuesIterator(io.servicetalk.http.api.HttpHeaderNames.CONNECTION);
        if (connectionItr.hasNext()) {
            do {
                CharSequence connectionHeader = connectionItr.next();
                connectionItr.remove();
                int i = HeaderUtils.indexOf(connectionHeader, ',', 0);
                if (i != -1) {
                    int start = 0;
                    do {
                        h1Headers.remove(connectionHeader.subSequence(start, i));
                        start = i + 1;
                        if (start >= connectionHeader.length() || connectionHeader.charAt(start) != ' ') continue;
                        ++start;
                    } while (start < connectionHeader.length() && (i = HeaderUtils.indexOf(connectionHeader, ',', start)) != -1);
                    h1Headers.remove(connectionHeader.subSequence(start, connectionHeader.length()));
                    continue;
                }
                h1Headers.remove(connectionHeader);
            } while (connectionItr.hasNext());
        }
        h1Headers.remove(io.servicetalk.http.api.HttpHeaderValues.KEEP_ALIVE);
        h1Headers.remove(io.servicetalk.http.api.HttpHeaderNames.TRANSFER_ENCODING);
        h1Headers.remove(io.servicetalk.http.api.HttpHeaderNames.UPGRADE);
        h1Headers.remove(PROXY_CONNECTION);
        Iterator<? extends CharSequence> teItr = h1Headers.valuesIterator(HttpHeaderNames.TE);
        boolean addTrailers = false;
        while (teItr.hasNext()) {
            CharSequence teSequence = teItr.next();
            if (addTrailers) {
                teItr.remove();
                continue;
            }
            int i = HeaderUtils.indexOf(teSequence, ',', 0);
            if (i != -1) {
                int start = 0;
                do {
                    if (CharSequences.contentEqualsIgnoreCase(teSequence.subSequence(start, i), HttpHeaderValues.TRAILERS)) {
                        addTrailers = true;
                        break;
                    }
                    start = i + 1;
                    if (start >= teSequence.length() || teSequence.charAt(start) != ' ') continue;
                    ++start;
                } while (start < teSequence.length() && (i = HeaderUtils.indexOf(teSequence, ',', start)) != -1);
                if (!addTrailers && start < teSequence.length() && CharSequences.contentEqualsIgnoreCase(teSequence.subSequence(start, teSequence.length()), HttpHeaderValues.TRAILERS)) {
                    addTrailers = true;
                }
                teItr.remove();
                continue;
            }
            if (CharSequences.contentEqualsIgnoreCase(teSequence, HttpHeaderValues.TRAILERS)) continue;
            teItr.remove();
        }
        if (addTrailers) {
            h1Headers.add((CharSequence)HttpHeaderNames.TE, (CharSequence)HttpHeaderValues.TRAILERS);
        }
        H2ToStH1Utils.h1HeadersSplitCookieCrumbs(h1Headers);
        if (h1Headers instanceof NettyH2HeadersToHttpHeaders) {
            return ((NettyH2HeadersToHttpHeaders)h1Headers).nettyHeaders();
        }
        if (h1Headers.isEmpty()) {
            return new DefaultHttp2Headers(false, 0);
        }
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers(false);
        for (Map.Entry<CharSequence, CharSequence> h1Entry : h1Headers) {
            http2Headers.add(h1Entry.getKey().toString().toLowerCase(), h1Entry.getValue());
        }
        return http2Headers;
    }
}

