/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.netty.DefaultKeepAlivePolicy;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.utils.internal.DurationUtils;
import java.time.Duration;
import java.util.Objects;

public final class H2KeepAlivePolicies {
    static final Duration DEFAULT_IDLE_DURATION = Duration.ofSeconds(30L);
    static final Duration DEFAULT_ACK_TIMEOUT = Duration.ofSeconds(5L);
    private static final H2ProtocolConfig.KeepAlivePolicy DISABLE_KEEP_ALIVE = new DefaultKeepAlivePolicy(Duration.ZERO, DEFAULT_ACK_TIMEOUT, false);

    private H2KeepAlivePolicies() {
    }

    public static H2ProtocolConfig.KeepAlivePolicy disabled() {
        return DISABLE_KEEP_ALIVE;
    }

    public static H2ProtocolConfig.KeepAlivePolicy whenIdleFor(Duration idleDuration) {
        DurationUtils.ensureNonNegative(idleDuration, "idleDuration");
        if (idleDuration.isZero()) {
            return H2KeepAlivePolicies.disabled();
        }
        return new KeepAlivePolicyBuilder().idleDuration(idleDuration).build();
    }

    public static H2ProtocolConfig.KeepAlivePolicy whenIdleFor(Duration idleDuration, Duration ackTimeout) {
        return new KeepAlivePolicyBuilder().idleDuration(idleDuration).ackTimeout(ackTimeout).build();
    }

    static H2ProtocolConfig.KeepAlivePolicy validateKeepAlivePolicy(H2ProtocolConfig.KeepAlivePolicy keepAlivePolicy) {
        Objects.requireNonNull(keepAlivePolicy, "keepAlivePolicy");
        DurationUtils.ensureNonNegative(keepAlivePolicy.idleDuration(), "idleDuration");
        DurationUtils.ensurePositive(keepAlivePolicy.ackTimeout(), "ackTimeout");
        return keepAlivePolicy;
    }

    public static final class KeepAlivePolicyBuilder {
        private Duration idleDuration = DEFAULT_IDLE_DURATION;
        private Duration ackTimeout = DEFAULT_ACK_TIMEOUT;
        private boolean withoutActiveStreams;

        public KeepAlivePolicyBuilder idleDuration(Duration idleDuration) {
            this.idleDuration = DurationUtils.ensureNonNegative(idleDuration, "idleDuration");
            return this;
        }

        public KeepAlivePolicyBuilder ackTimeout(Duration ackTimeout) {
            this.ackTimeout = DurationUtils.ensurePositive(ackTimeout, "ackTimeout");
            return this;
        }

        public KeepAlivePolicyBuilder withoutActiveStreams(boolean withoutActiveStreams) {
            this.withoutActiveStreams = withoutActiveStreams;
            return this;
        }

        public H2ProtocolConfig.KeepAlivePolicy build() {
            return new DefaultKeepAlivePolicy(this.idleDuration, this.ackTimeout, this.withoutActiveStreams);
        }
    }
}

