/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscoverers;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.netty.internal.BuilderUtils;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GlobalDnsServiceDiscoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalDnsServiceDiscoverer.class);

    private GlobalDnsServiceDiscoverer() {
    }

    static ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> globalDnsServiceDiscoverer() {
        return HostAndPortClientInitializer.HOST_PORT_SD;
    }

    static ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> globalSrvDnsServiceDiscoverer() {
        return SrvClientInitializer.SRV_SD;
    }

    static ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> resolvedServiceDiscoverer() {
        return ResolvedServiceDiscovererInitializer.RESOLVED_SD;
    }

    static ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> unresolvedServiceDiscoverer() {
        return UnresolvedServiceDiscovererInitializer.UNRESOLVED_SD;
    }

    static <U, R> ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> mappingServiceDiscoverer(Function<U, R> toResolvedAddressMapper, String description) {
        return new MappingServiceDiscoverer(toResolvedAddressMapper, description);
    }

    private static final class MappingServiceDiscoverer<UnresolvedAddress, ResolvedAddress>
    implements ServiceDiscoverer<UnresolvedAddress, ResolvedAddress, ServiceDiscovererEvent<ResolvedAddress>> {
        private final Function<UnresolvedAddress, ResolvedAddress> toResolvedAddressMapper;
        private final String description;
        private final ListenableAsyncCloseable closeable = AsyncCloseables.emptyAsyncCloseable();

        private MappingServiceDiscoverer(Function<UnresolvedAddress, ResolvedAddress> toResolvedAddressMapper, String description) {
            this.toResolvedAddressMapper = Objects.requireNonNull(toResolvedAddressMapper);
            this.description = Objects.requireNonNull(description);
        }

        @Override
        public Publisher<Collection<ServiceDiscovererEvent<ResolvedAddress>>> discover(UnresolvedAddress address) {
            return Single.succeeded(Collections.singletonList(new DefaultServiceDiscovererEvent<ResolvedAddress>(Objects.requireNonNull(this.toResolvedAddressMapper.apply(address)), ServiceDiscovererEvent.Status.AVAILABLE))).concat(Publisher.never());
        }

        @Override
        public Completable onClose() {
            return this.closeable.onClose();
        }

        @Override
        public Completable onClosing() {
            return this.closeable.onClosing();
        }

        @Override
        public Completable closeAsync() {
            return this.closeable.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.closeable.closeAsyncGracefully();
        }

        public String toString() {
            return this.getClass().getSimpleName() + '{' + this.description + '}';
        }
    }

    private static final class UnresolvedServiceDiscovererInitializer {
        static final ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> UNRESOLVED_SD = GlobalDnsServiceDiscoverer.mappingServiceDiscoverer(hostAndPort -> InetSocketAddress.createUnresolved(hostAndPort.hostName(), hostAndPort.port()), "from " + HostAndPort.class.getSimpleName() + " to an unresolved " + InetSocketAddress.class.getSimpleName());

        private UnresolvedServiceDiscovererInitializer() {
        }

        static {
            LOGGER.debug("Initialized {}", (Object)UnresolvedServiceDiscovererInitializer.class);
        }
    }

    private static final class ResolvedServiceDiscovererInitializer {
        static final ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> RESOLVED_SD = GlobalDnsServiceDiscoverer.mappingServiceDiscoverer(BuilderUtils::toResolvedInetSocketAddress, "from " + HostAndPort.class.getSimpleName() + " to a resolved " + InetSocketAddress.class.getSimpleName());

        private ResolvedServiceDiscovererInitializer() {
        }

        static {
            LOGGER.debug("Initialized {}", (Object)ResolvedServiceDiscovererInitializer.class);
        }
    }

    private static final class SrvClientInitializer {
        static final ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> SRV_SD = DnsServiceDiscoverers.builder("global-srv").buildSrvDiscoverer();

        private SrvClientInitializer() {
        }

        static {
            LOGGER.debug("Initialized {}", (Object)SrvClientInitializer.class);
        }
    }

    private static final class HostAndPortClientInitializer {
        static final ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> HOST_PORT_SD = DnsServiceDiscoverers.builder("global-a").buildARecordDiscoverer();

        private HostAndPortClientInitializer() {
        }

        static {
            LOGGER.debug("Initialized {}", (Object)HostAndPortClientInitializer.class);
        }
    }
}

