/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.netty.AlpnChannelSingle;
import io.servicetalk.http.netty.H2ServerParentConnectionContext;
import io.servicetalk.http.netty.NettyHttpServer;
import io.servicetalk.http.netty.ReadOnlyHttpServerConfig;
import io.servicetalk.http.netty.SniCompleteChannelSingle;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.tcp.netty.internal.TcpServerBinder;
import io.servicetalk.tcp.netty.internal.TcpServerChannelInitializer;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.EarlyConnectionAcceptor;
import io.servicetalk.transport.api.LateConnectionAcceptor;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.netty.internal.InfluencerConnectionAcceptor;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import java.net.SocketAddress;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeferredServerChannelBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeferredServerChannelBinder.class);

    private DeferredServerChannelBinder() {
    }

    static Single<HttpServerContext> bind(HttpExecutionContext executionContext, ReadOnlyHttpServerConfig config, SocketAddress listenAddress, @Nullable InfluencerConnectionAcceptor connectionAcceptor, StreamingHttpService service, boolean drainRequestPayloadBody, boolean sniOnly, @Nullable EarlyConnectionAcceptor earlyConnectionAcceptor, @Nullable LateConnectionAcceptor lateConnectionAcceptor) {
        ReadOnlyTcpServerConfig tcpConfig = config.tcpConfig();
        assert (tcpConfig.sslContext() != null);
        BiFunction channelInit = sniOnly ? (channel, connectionObserver) -> DeferredServerChannelBinder.sniInitChannel(listenAddress, channel, config, executionContext, service, drainRequestPayloadBody, connectionObserver) : (channel, connectionObserver) -> DeferredServerChannelBinder.alpnInitChannel(listenAddress, channel, config, executionContext, service, drainRequestPayloadBody, connectionObserver);
        return TcpServerBinder.bind(listenAddress, tcpConfig, executionContext, connectionAcceptor, channelInit, serverConnection -> {
            if (serverConnection instanceof NettyHttpServer.NettyHttpServerConnection) {
                ((NettyHttpServer.NettyHttpServerConnection)serverConnection).process(true);
            }
        }, earlyConnectionAcceptor, lateConnectionAcceptor).map(delegate -> {
            LOGGER.debug("Started HTTP server with ALPN for address {}", (Object)delegate.listenAddress());
            return new NettyHttpServer.NettyHttpServerContext((ServerContext)delegate, service, executionContext);
        });
    }

    private static Single<NettyConnectionContext> alpnInitChannel(SocketAddress listenAddress, Channel channel, ReadOnlyHttpServerConfig config, HttpExecutionContext httpExecutionContext, StreamingHttpService service, boolean drainRequestPayloadBody, ConnectionObserver observer) {
        return new AlpnChannelSingle(channel, new TcpServerChannelInitializer(config.tcpConfig(), observer, httpExecutionContext), ChannelHandlerContext::read).flatMap(protocol -> {
            switch (protocol) {
                case "http/1.1": {
                    return NettyHttpServer.initChannel(channel, httpExecutionContext, config, AlpnChannelSingle.NoopChannelInitializer.INSTANCE, service, drainRequestPayloadBody, observer);
                }
                case "h2": {
                    return H2ServerParentConnectionContext.initChannel(listenAddress, channel, httpExecutionContext, config, AlpnChannelSingle.NoopChannelInitializer.INSTANCE, service, drainRequestPayloadBody, observer);
                }
            }
            return Single.failed(new IllegalStateException("Unknown ALPN protocol negotiated: " + protocol));
        });
    }

    private static Single<NettyConnectionContext> sniInitChannel(SocketAddress listenAddress, Channel channel, ReadOnlyHttpServerConfig config, HttpExecutionContext httpExecutionContext, StreamingHttpService service, boolean drainRequestPayloadBody, ConnectionObserver observer) {
        return new SniCompleteChannelSingle(channel, new TcpServerChannelInitializer(config.tcpConfig(), observer, httpExecutionContext)).flatMap(sniEvt -> {
            Throwable failureCause = sniEvt.cause();
            if (failureCause != null) {
                return Single.failed(failureCause);
            }
            if (config.h2Config() != null) {
                return H2ServerParentConnectionContext.initChannel(listenAddress, channel, httpExecutionContext, config, AlpnChannelSingle.NoopChannelInitializer.INSTANCE, service, drainRequestPayloadBody, observer);
            }
            if (config.h1Config() != null) {
                return NettyHttpServer.initChannel(channel, httpExecutionContext, config, AlpnChannelSingle.NoopChannelInitializer.INSTANCE, service, drainRequestPayloadBody, observer);
            }
            return Single.failed(new IllegalStateException("SSL handshake completed, but no protocols to initialize. Consider using ALPN to explicitly negotiate the protocol and/or configure protocols on the client/server builder."));
        });
    }
}

