/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.http.api.ConnectAndHttpExecutionStrategy;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.transport.api.ConnectExecutionStrategy;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.ExecutionStrategyInfluencer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientStrategyInfluencerChainBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientStrategyInfluencerChainBuilder.class);
    @Nullable
    private ConnectAndHttpExecutionStrategy connFactoryChain;
    @Nullable
    private HttpExecutionStrategy connFilterChain;
    @Nullable
    private HttpExecutionStrategy clientChain;

    ClientStrategyInfluencerChainBuilder() {
        this.connFactoryChain = null;
        this.connFilterChain = null;
        this.clientChain = null;
    }

    private ClientStrategyInfluencerChainBuilder(ClientStrategyInfluencerChainBuilder from) {
        this.connFactoryChain = from.connFactoryChain;
        this.connFilterChain = from.connFilterChain;
        this.clientChain = from.clientChain;
    }

    void add(StreamingHttpClientFilterFactory clientFilter) {
        this.add(StreamingHttpClientFilterFactory.class, clientFilter, clientFilter.requiredOffloads());
    }

    void add(HttpLoadBalancerFactory<?> lb) {
        this.add(HttpLoadBalancerFactory.class, lb, lb.requiredOffloads());
    }

    private <T extends ExecutionStrategyInfluencer<HttpExecutionStrategy>> void add(Class<T> clazz, T influencer, HttpExecutionStrategy strategy) {
        HttpExecutionStrategy clientChain;
        if (HttpExecutionStrategies.offloadNever() == strategy) {
            ClientStrategyInfluencerChainBuilder.offloadNeverWarning(clazz, influencer);
            strategy = HttpExecutionStrategies.offloadNone();
        }
        if (HttpExecutionStrategies.defaultStrategy() == strategy) {
            ClientStrategyInfluencerChainBuilder.defaultStrategyWarning(clazz, influencer);
            strategy = HttpExecutionStrategies.offloadAll();
        }
        this.clientChain = null != (clientChain = this.clientChain) ? clientChain.merge(strategy) : strategy;
        ClientStrategyInfluencerChainBuilder.logIfChanges(clazz, influencer, clientChain, this.clientChain);
    }

    void add(ConnectionFactoryFilter<?, FilterableStreamingHttpConnection> connectionFactoryFilter) {
        ConnectAndHttpExecutionStrategy connFactoryChain;
        ExecutionStrategy filterOffloads = connectionFactoryFilter.requiredOffloads();
        if (HttpExecutionStrategies.offloadNever() == filterOffloads) {
            ClientStrategyInfluencerChainBuilder.offloadNeverWarning(ConnectionFactoryFilter.class, connectionFactoryFilter);
            filterOffloads = HttpExecutionStrategies.offloadNone();
        }
        if (HttpExecutionStrategies.defaultStrategy() == filterOffloads) {
            ClientStrategyInfluencerChainBuilder.defaultStrategyWarning(ConnectionFactoryFilter.class, connectionFactoryFilter);
            filterOffloads = HttpExecutionStrategies.offloadAll();
        }
        this.connFactoryChain = null != (connFactoryChain = this.connFactoryChain) ? connFactoryChain.merge(filterOffloads) : ConnectAndHttpExecutionStrategy.from(filterOffloads);
        ClientStrategyInfluencerChainBuilder.logIfChanges(ConnectionFactoryFilter.class, connectionFactoryFilter, connFactoryChain, this.connFactoryChain);
    }

    void add(StreamingHttpConnectionFilterFactory connectionFilter) {
        HttpExecutionStrategy filterOffloads = connectionFilter.requiredOffloads();
        if (HttpExecutionStrategies.offloadNever() == filterOffloads) {
            ClientStrategyInfluencerChainBuilder.offloadNeverWarning(StreamingHttpConnectionFilterFactory.class, connectionFilter);
            filterOffloads = HttpExecutionStrategies.offloadNone();
        }
        if (HttpExecutionStrategies.defaultStrategy() == filterOffloads) {
            ClientStrategyInfluencerChainBuilder.defaultStrategyWarning(StreamingHttpConnectionFilterFactory.class, connectionFilter);
            filterOffloads = HttpExecutionStrategies.offloadAll();
        }
        if (filterOffloads.hasOffloads()) {
            HttpExecutionStrategy connFilterChain = this.connFilterChain;
            this.connFilterChain = null != connFilterChain ? connFilterChain.merge(filterOffloads) : filterOffloads;
            ClientStrategyInfluencerChainBuilder.logIfChanges(StreamingHttpConnectionFilterFactory.class, connectionFilter, connFilterChain, this.connFilterChain);
        }
    }

    HttpExecutionStrategy buildForClient(HttpExecutionStrategy builderStrategy) {
        HttpExecutionStrategy chainStrategy = this.clientChain;
        if (null != this.connFilterChain) {
            HttpExecutionStrategy httpExecutionStrategy = chainStrategy = null != chainStrategy ? chainStrategy.merge(this.connFilterChain) : this.connFilterChain;
        }
        if (null != this.connFactoryChain) {
            HttpExecutionStrategy connectionFactoryStrategy = HttpExecutionStrategy.from(this.buildForConnectionFactory());
            HttpExecutionStrategy httpExecutionStrategy = chainStrategy = null != chainStrategy ? chainStrategy.merge(connectionFactoryStrategy) : connectionFactoryStrategy;
        }
        return null == chainStrategy || !chainStrategy.hasOffloads() ? builderStrategy : (HttpExecutionStrategies.defaultStrategy() == builderStrategy ? chainStrategy : (builderStrategy.hasOffloads() ? chainStrategy.merge(builderStrategy) : builderStrategy));
    }

    ExecutionStrategy buildForConnectionFactory() {
        return null == this.connFactoryChain ? ExecutionStrategy.offloadNone() : (HttpExecutionStrategies.defaultStrategy() != this.connFactoryChain.httpStrategy() ? (ConnectExecutionStrategy.offloadNone() != this.connFactoryChain.connectStrategy() ? this.connFactoryChain : this.connFactoryChain.httpStrategy()) : (ConnectExecutionStrategy.offloadNone() != this.connFactoryChain.connectStrategy() ? this.connFactoryChain.connectStrategy() : ExecutionStrategy.offloadNone()));
    }

    ClientStrategyInfluencerChainBuilder copy() {
        return new ClientStrategyInfluencerChainBuilder(this);
    }

    private static <T extends ExecutionStrategyInfluencer<?>> void offloadNeverWarning(Class<T> clazz, T influencer) {
        LOGGER.warn("{}#requiredOffloads() returns offloadNever(), which is unexpected. offloadNone() should be used instead. Making automatic adjustment, update the {} to avoid this warning.", (Object)influencer, (Object)clazz.getSimpleName());
    }

    private static <T extends ExecutionStrategyInfluencer<?>> void defaultStrategyWarning(Class<T> clazz, T influencer) {
        LOGGER.warn("{}#requiredOffloads() returns defaultStrategy(), which is unexpected. offloadAll() (safe default) or more appropriate custom strategy should be used instead.Making automatic adjustment, update the {} to avoid this warning.", (Object)influencer, (Object)clazz.getSimpleName());
    }

    private static <T extends ExecutionStrategyInfluencer<?>> void logIfChanges(Class<T> clazz, T influencer, @Nullable ExecutionStrategy before, @Nullable ExecutionStrategy after) {
        if (before != after) {
            LOGGER.debug("{} '{}' changes execution strategy from '{}' to '{}'", clazz, influencer, before, after);
        }
    }
}

