/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.http.netty.ChannelInitSingle;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.StacklessClosedChannelException;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AlpnChannelSingle
extends ChannelInitSingle<String> {
    private final Consumer<ChannelHandlerContext> onHandlerAdded;

    AlpnChannelSingle(Channel channel, ChannelInitializer channelInitializer, Consumer<ChannelHandlerContext> onHandlerAdded) {
        super(channel, channelInitializer);
        this.onHandlerAdded = Objects.requireNonNull(onHandlerAdded);
    }

    @Override
    protected ChannelHandler newChannelHandler(SingleSource.Subscriber<? super String> subscriber) {
        return new AlpnChannelHandler(subscriber, this.onHandlerAdded);
    }

    static final class NoopChannelInitializer
    implements ChannelInitializer {
        static final ChannelInitializer INSTANCE = new NoopChannelInitializer();

        private NoopChannelInitializer() {
        }

        @Override
        public void init(Channel channel) {
        }

        @Override
        public ChannelInitializer andThen(ChannelInitializer after) {
            return after;
        }
    }

    private static final class AlpnChannelHandler
    extends ApplicationProtocolNegotiationHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(AlpnChannelHandler.class);
        @Nullable
        private SingleSource.Subscriber<? super String> subscriber;
        private final Consumer<ChannelHandlerContext> onHandlerAdded;

        AlpnChannelHandler(SingleSource.Subscriber<? super String> subscriber, Consumer<ChannelHandlerContext> onHandlerAdded) {
            super("http/1.1");
            this.subscriber = subscriber;
            this.onHandlerAdded = onHandlerAdded;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            this.onHandlerAdded.accept(ctx);
        }

        @Override
        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            LOGGER.debug("{} ALPN negotiated {} protocol", (Object)ctx.channel(), (Object)protocol);
            assert (this.subscriber != null);
            SingleSource.Subscriber<? super String> subscriberCopy = this.subscriber;
            this.subscriber = null;
            subscriberCopy.onSuccess(protocol);
        }

        @Override
        protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) {
            LOGGER.warn("{} TLS handshake failed:", (Object)ctx.channel(), (Object)cause);
            if (!this.failSubscriber(cause, ctx.channel())) {
                ChannelCloseUtils.close(ctx, cause);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            Throwable wrapped;
            if (cause instanceof DecoderException && (wrapped = cause.getCause()) instanceof SSLException) {
                this.handshakeFailure(ctx, wrapped);
                return;
            }
            LOGGER.warn("{} Failed to select the application-level protocol:", (Object)ctx.channel(), (Object)cause);
            if (!this.failSubscriber(cause, ctx.channel())) {
                ctx.fireExceptionCaught(cause);
                ChannelCloseUtils.close(ctx, cause);
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.subscriber != null) {
                this.failSubscriber(StacklessClosedChannelException.newInstance(AlpnChannelHandler.class, "channelInactive(...)"), ctx.channel());
            }
            super.channelInactive(ctx);
        }

        private boolean failSubscriber(Throwable cause, Channel channel) {
            ChannelCloseUtils.assignConnectionError(channel, cause);
            if (this.subscriber != null) {
                SingleSource.Subscriber<? super String> subscriberCopy = this.subscriber;
                this.subscriber = null;
                subscriberCopy.onError(cause);
                return true;
            }
            return false;
        }
    }
}

