/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.ReservableRequestConcurrencyController;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.H2ClientParentConnectionContext;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.http.netty.ReservableRequestConcurrencyControllers;
import io.servicetalk.transport.api.ConnectExecutionStrategy;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoThreadFactory;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.api.TransportObservers;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

abstract class AbstractLBHttpConnectionFactory<ResolvedAddress>
implements ConnectionFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> {
    @Nullable
    private final StreamingHttpConnectionFilterFactory connectionFilterFunction;
    final ReadOnlyHttpClientConfig config;
    final HttpExecutionContext executionContext;
    final Function<HttpProtocolVersion, StreamingHttpRequestResponseFactory> reqRespFactoryFunc;
    private final ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection> filterableConnectionFactory;
    private final ProtocolBinding protocolBinding;

    AbstractLBHttpConnectionFactory(ReadOnlyHttpClientConfig config, final HttpExecutionContext executionContext, Function<HttpProtocolVersion, StreamingHttpRequestResponseFactory> reqRespFactoryFunc, final ExecutionStrategy connectStrategy, ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> connectionFactoryFilter, @Nullable StreamingHttpConnectionFilterFactory connectionFilterFunction, ProtocolBinding protocolBinding) {
        this.connectionFilterFunction = connectionFilterFunction;
        this.config = Objects.requireNonNull(config);
        this.executionContext = Objects.requireNonNull(executionContext);
        this.reqRespFactoryFunc = Objects.requireNonNull(reqRespFactoryFunc);
        Objects.requireNonNull(connectStrategy);
        this.protocolBinding = Objects.requireNonNull(protocolBinding);
        this.filterableConnectionFactory = connectionFactoryFilter.create(new ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection>(){
            private final ListenableAsyncCloseable close = AsyncCloseables.emptyAsyncCloseable();

            @Override
            public Single<FilterableStreamingHttpConnection> newConnection(ResolvedAddress ra, @Nullable ContextMap context, @Nullable TransportObserver observer) {
                Single<FilterableStreamingHttpConnection> connection = AbstractLBHttpConnectionFactory.this.newFilterableConnection(Objects.requireNonNull(ra, "Resolved address cannot be null"), observer == null ? NoopTransportObserver.INSTANCE : TransportObservers.asSafeObserver(observer));
                return connectStrategy instanceof ConnectExecutionStrategy && ((ConnectExecutionStrategy)connectStrategy).isConnectOffloaded() ? connection.publishOn(executionContext.executor(), IoThreadFactory.IoThread::currentThreadIsIoThread) : connection;
            }

            @Override
            public Completable onClose() {
                return this.close.onClose();
            }

            @Override
            public Completable onClosing() {
                return this.close.onClosing();
            }

            @Override
            public Completable closeAsync() {
                return this.close.closeAsync();
            }

            @Override
            public Completable closeAsyncGracefully() {
                return this.close.closeAsyncGracefully();
            }
        });
    }

    @Override
    public final Single<FilterableStreamingHttpLoadBalancedConnection> newConnection(ResolvedAddress resolvedAddress, @Nullable ContextMap context, @Nullable TransportObserver observer) {
        return this.filterableConnectionFactory.newConnection(resolvedAddress, context, observer).map(conn -> {
            FilterableStreamingHttpConnection filteredConnection = this.connectionFilterFunction != null ? this.connectionFilterFunction.create((FilterableStreamingHttpConnection)conn) : conn;
            return this.protocolBinding.bind(filteredConnection, this.newConcurrencyController(filteredConnection), context);
        });
    }

    abstract Single<FilterableStreamingHttpConnection> newFilterableConnection(ResolvedAddress var1, TransportObserver var2);

    private ReservableRequestConcurrencyController newConcurrencyController(FilterableStreamingHttpConnection connection) {
        int initialConcurrency;
        HttpProtocolVersion protocol = connection.connectionContext().protocol();
        if (protocol.major() == HttpProtocolVersion.HTTP_2_0.major()) {
            assert (this.config.h2Config() != null);
            initialConcurrency = H2ClientParentConnectionContext.DEFAULT_H2_MAX_CONCURRENCY_EVENT.event();
        } else if (protocol.major() == HttpProtocolVersion.HTTP_1_1.major()) {
            if (protocol.minor() >= HttpProtocolVersion.HTTP_1_1.minor()) {
                assert (this.config.h1Config() != null);
                initialConcurrency = this.config.h1Config().maxPipelinedRequests();
            } else {
                initialConcurrency = 1;
            }
        } else {
            throw new IllegalStateException("Cannot infer initialConcurrency value for unknown protocol: " + protocol);
        }
        return ReservableRequestConcurrencyControllers.newController(connection, initialConcurrency);
    }

    @Override
    public final Completable onClose() {
        return this.filterableConnectionFactory.onClose();
    }

    @Override
    public final Completable onClosing() {
        return this.filterableConnectionFactory.onClosing();
    }

    @Override
    public final Completable closeAsync() {
        return this.filterableConnectionFactory.closeAsync();
    }

    @Override
    public final Completable closeAsyncGracefully() {
        return this.filterableConnectionFactory.closeAsyncGracefully();
    }

    @FunctionalInterface
    static interface ProtocolBinding {
        public FilterableStreamingHttpLoadBalancedConnection bind(FilterableStreamingHttpConnection var1, ReservableRequestConcurrencyController var2, @Nullable ContextMap var3);
    }
}

