/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.util.ReferenceCountUtil;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.http.api.Http2ErrorCode;
import io.servicetalk.http.api.Http2Exception;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.netty.H2ToStH1Utils;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.HttpObjectEncoder;
import io.servicetalk.http.netty.NettyHttp2ExceptionUtils;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.CloseHandler;
import javax.annotation.Nullable;

abstract class AbstractH2DuplexHandler
extends ChannelDuplexHandler {
    final BufferAllocator allocator;
    final HttpHeadersFactory headersFactory;
    final CloseHandler closeHandler;
    final ConnectionObserver.StreamObserver observer;

    AbstractH2DuplexHandler(BufferAllocator allocator, HttpHeadersFactory headersFactory, CloseHandler closeHandler, ConnectionObserver.StreamObserver observer) {
        this.allocator = allocator;
        this.headersFactory = headersFactory;
        this.closeHandler = closeHandler;
        this.observer = observer;
    }

    @Override
    public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof Http2ResetFrame) {
            ctx.fireExceptionCaught(NettyHttp2ExceptionUtils.newStreamResetException((Http2ResetFrame)evt));
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    final void writeMetaData(ChannelHandlerContext ctx, HttpMetaData metaData, Http2Headers h2Headers, boolean realMessage, ChannelPromise promise) {
        boolean endStream;
        boolean bl = endStream = realMessage && HeaderUtils.emptyMessageBody(metaData);
        if (endStream) {
            this.closeHandler.protocolPayloadEndOutbound(ctx, promise);
        }
        DefaultHttp2HeadersFrame frame = new DefaultHttp2HeadersFrame(h2Headers, endStream);
        if (realMessage) {
            ctx.write(frame, promise);
        } else {
            ctx.writeAndFlush(frame, promise);
        }
    }

    static void writeBuffer(ChannelHandlerContext ctx, Buffer buffer, ChannelPromise promise) {
        ctx.write(new DefaultHttp2DataFrame(HttpObjectEncoder.encodeAndRetain(buffer), false), promise);
    }

    final void writeTrailers(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.closeHandler.protocolPayloadEndOutbound(ctx, promise);
        HttpHeaders trailers = (HttpHeaders)msg;
        if (trailers.isEmpty()) {
            AbstractH2DuplexHandler.writeEmptyEndStream(ctx, promise);
        } else {
            Http2Headers h2Headers = H2ToStH1Utils.h1HeadersToH2Headers(trailers);
            if (h2Headers.isEmpty()) {
                AbstractH2DuplexHandler.writeEmptyEndStream(ctx, promise);
            } else {
                ctx.write(new DefaultHttp2HeadersFrame(h2Headers, true), promise);
            }
        }
    }

    private static void writeEmptyEndStream(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.write(new DefaultHttp2DataFrame(true), promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void readDataFrame(ChannelHandlerContext ctx, Object msg) {
        Object toRelease = msg;
        try {
            Http2DataFrame dataFrame = (Http2DataFrame)msg;
            int readableBytes = dataFrame.content().readableBytes();
            if (readableBytes > 0) {
                Buffer data = this.allocator.newBuffer(readableBytes);
                ByteBuf nettyData = BufferUtils.toByteBuf(data);
                nettyData.writeBytes(dataFrame.content());
                toRelease = AbstractH2DuplexHandler.release(dataFrame);
                ctx.fireChannelRead(data);
            } else {
                toRelease = AbstractH2DuplexHandler.release(dataFrame);
            }
            if (dataFrame.isEndStream()) {
                this.closeHandler.protocolPayloadEndInbound(ctx);
            }
        }
        finally {
            if (toRelease != null) {
                ReferenceCountUtil.release(toRelease);
            }
        }
    }

    @Nullable
    private static Http2DataFrame release(Http2DataFrame dataFrame) {
        dataFrame.release();
        return null;
    }

    @Override
    public final void channelInactive(ChannelHandlerContext ctx) {
        Throwable t = ChannelCloseUtils.channelError(ctx.channel());
        if (t == null) {
            this.observer.streamClosed();
        } else {
            this.observer.streamClosed(t);
        }
        ctx.fireChannelInactive();
    }

    static Http2Exception protocolError(ChannelHandlerContext ctx, int streamId, boolean endStream, String message) {
        if (!endStream) {
            ctx.writeAndFlush(new DefaultHttp2ResetFrame(Http2Error.PROTOCOL_ERROR));
        }
        return new Http2Exception(streamId, Http2ErrorCode.PROTOCOL_ERROR, message);
    }
}

