/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.client.api.RequestConcurrencyController;
import io.servicetalk.client.api.ReservableRequestConcurrencyController;
import io.servicetalk.client.api.ScoreSupplier;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedBlockingHttpConnection;
import io.servicetalk.http.api.ReservedBlockingStreamingHttpConnection;
import io.servicetalk.http.api.ReservedHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Nullable;

public interface HttpLoadBalancerFactory<ResolvedAddress>
extends LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> {
    @Deprecated
    default public FilterableStreamingHttpLoadBalancedConnection toLoadBalancedConnection(FilterableStreamingHttpConnection connection) {
        throw new UnsupportedOperationException("HttpLoadBalancerFactory#toLoadBalancedConnection(FilterableStreamingHttpConnection) is not implemented by " + this.getClass() + ". This method is deprecated, consider migrating to HttpLoadBalancerFactory#toLoadBalancedConnection(FilterableStreamingHttpConnection, ReservableRequestConcurrencyController) or implement this method if it's required temporarily.");
    }

    default public FilterableStreamingHttpLoadBalancedConnection toLoadBalancedConnection(FilterableStreamingHttpConnection connection, ReservableRequestConcurrencyController concurrencyController, @Nullable ContextMap context) {
        boolean defaultOriginalMethod;
        try {
            Method originalMethod = this.getClass().getMethod("toLoadBalancedConnection", FilterableStreamingHttpConnection.class);
            defaultOriginalMethod = originalMethod.getDeclaringClass() == HttpLoadBalancerFactory.class && originalMethod.isDefault();
        }
        catch (NoSuchMethodException impossible) {
            defaultOriginalMethod = true;
        }
        if (defaultOriginalMethod) {
            return new DefaultFilterableStreamingHttpLoadBalancedConnection(connection, concurrencyController);
        }
        FilterableStreamingHttpLoadBalancedConnection original = this.toLoadBalancedConnection(connection);
        return new DefaultFilterableStreamingHttpLoadBalancedConnection(original, concurrencyController, original);
    }

    @Override
    default public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadAll();
    }

    public static final class DefaultFilterableStreamingHttpLoadBalancedConnection
    implements FilterableStreamingHttpLoadBalancedConnection {
        private final FilterableStreamingHttpConnection delegate;
        private final ReservableRequestConcurrencyController controller;
        private final ScoreSupplier scoreSupplier;

        public DefaultFilterableStreamingHttpLoadBalancedConnection(FilterableStreamingHttpConnection delegate, ReservableRequestConcurrencyController controller) {
            this(delegate, controller, () -> {
                throw new UnsupportedOperationException(DefaultFilterableStreamingHttpLoadBalancedConnection.class.getName() + " doesn't support scoring. " + ScoreSupplier.class.getName() + " is only available through " + HttpLoadBalancerFactory.class.getSimpleName() + " implementations that support scoring.");
            });
        }

        public DefaultFilterableStreamingHttpLoadBalancedConnection(FilterableStreamingHttpConnection delegate, ReservableRequestConcurrencyController controller, ScoreSupplier scoreSupplier) {
            this.delegate = Objects.requireNonNull(delegate);
            this.controller = Objects.requireNonNull(controller);
            this.scoreSupplier = Objects.requireNonNull(scoreSupplier);
        }

        @Override
        public int score() {
            return this.scoreSupplier.score();
        }

        @Override
        public HttpConnectionContext connectionContext() {
            return this.delegate.connectionContext();
        }

        @Override
        public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
            return this.delegate.transportEventStream(eventKey);
        }

        @Override
        public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
            return this.delegate.request(request);
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.delegate.executionContext();
        }

        @Override
        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.delegate.httpResponseFactory();
        }

        @Override
        public Completable onClose() {
            return this.delegate.onClose();
        }

        @Override
        public Completable onClosing() {
            return this.delegate.onClosing();
        }

        @Override
        public Completable closeAsync() {
            return this.delegate.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.delegate.closeAsyncGracefully();
        }

        @Override
        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.delegate.newRequest(method, requestTarget);
        }

        @Override
        public RequestConcurrencyController.Result tryRequest() {
            return this.controller.tryRequest();
        }

        @Override
        public void requestFinished() {
            this.controller.requestFinished();
        }

        @Override
        public boolean tryReserve() {
            return this.controller.tryReserve();
        }

        @Override
        public Completable releaseAsync() {
            return this.controller.releaseAsync();
        }

        @Override
        public ReservedHttpConnection asConnection() {
            return HttpApiConversions.toReservedConnection((ReservedStreamingHttpConnection)this, this.executionContext().executionStrategy());
        }

        @Override
        public ReservedBlockingStreamingHttpConnection asBlockingStreamingConnection() {
            return HttpApiConversions.toReservedBlockingStreamingConnection((ReservedStreamingHttpConnection)this, this.executionContext().executionStrategy());
        }

        @Override
        public ReservedBlockingHttpConnection asBlockingConnection() {
            return HttpApiConversions.toReservedBlockingConnection((ReservedStreamingHttpConnection)this, this.executionContext().executionStrategy());
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

