/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.EmptyBuffer;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.CloseableIterator;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.DelegatingToBufferHttpPayloadWriter;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.serialization.api.SerializationException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class FormUrlEncodedHttpSerializer
implements HttpSerializer<Map<String, List<String>>> {
    static final FormUrlEncodedHttpSerializer UTF8 = new FormUrlEncodedHttpSerializer(StandardCharsets.UTF_8, headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED_UTF_8));
    private static final byte EQUALS_BYTE = 61;
    private static final byte AMPERSAND_BYTE = 38;
    private final Charset charset;
    private final boolean isOptimizedCharset;
    private final Consumer<HttpHeaders> addContentType;

    FormUrlEncodedHttpSerializer(Charset charset, Consumer<HttpHeaders> addContentType) {
        this.charset = charset;
        this.addContentType = addContentType;
        this.isOptimizedCharset = StandardCharsets.UTF_8.equals(charset) || StandardCharsets.US_ASCII.equals(charset);
    }

    @Override
    public Buffer serialize(HttpHeaders headers, Map<String, List<String>> parameters, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return this.serialize(parameters, allocator, false);
    }

    @Override
    public BlockingIterable<Buffer> serialize(HttpHeaders headers, BlockingIterable<Map<String, List<String>>> parameters, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return () -> {
            CloseableIterator iterator = parameters.iterator();
            return new BlockingIterator<Buffer>((BlockingIterator)iterator, allocator){
                private boolean isContinuation;
                final /* synthetic */ BlockingIterator val$iterator;
                final /* synthetic */ BufferAllocator val$allocator;
                {
                    this.val$iterator = blockingIterator;
                    this.val$allocator = bufferAllocator;
                }

                @Override
                public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                    return this.val$iterator.hasNext(timeout, unit);
                }

                @Override
                public Buffer next(long timeout, TimeUnit unit) throws TimeoutException {
                    Map next = (Map)this.val$iterator.next(timeout, unit);
                    Buffer buffer = FormUrlEncodedHttpSerializer.this.serialize(next, this.val$allocator, this.isContinuation);
                    this.isContinuation = this.isContinuation || buffer.readableBytes() > 0;
                    return buffer;
                }

                @Override
                public void close() throws Exception {
                    this.val$iterator.close();
                }

                @Override
                public boolean hasNext() {
                    return this.val$iterator.hasNext();
                }

                @Override
                public Buffer next() {
                    Map next = (Map)this.val$iterator.next();
                    Buffer buffer = FormUrlEncodedHttpSerializer.this.serialize(next, this.val$allocator, this.isContinuation);
                    this.isContinuation = this.isContinuation || buffer.readableBytes() > 0;
                    return buffer;
                }
            };
        };
    }

    @Override
    public Publisher<Buffer> serialize(HttpHeaders headers, Publisher<Map<String, List<String>>> parameters, final BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return parameters.liftSync(subscriber -> new PublisherSource.Subscriber<Map<String, List<String>>>(){
            private boolean isContinuation;

            @Override
            public void onSubscribe(PublisherSource.Subscription subscription) {
                subscriber.onSubscribe(subscription);
            }

            @Override
            public void onNext(@Nullable Map<String, List<String>> values) {
                Buffer buffer = FormUrlEncodedHttpSerializer.this.serialize(values, allocator, this.isContinuation);
                this.isContinuation = this.isContinuation || buffer.readableBytes() > 0;
                subscriber.onNext(buffer);
            }

            @Override
            public void onError(Throwable t) {
                subscriber.onError(t);
            }

            @Override
            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }

    @Override
    public HttpPayloadWriter<Map<String, List<String>>> serialize(HttpHeaders headers, HttpPayloadWriter<Buffer> payloadWriter, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return new DelegatingToBufferHttpPayloadWriter<Map<String, List<String>>>(payloadWriter, allocator){
            private boolean isContinuation;

            @Override
            public void write(Map<String, List<String>> values) throws IOException {
                Buffer buffer = FormUrlEncodedHttpSerializer.this.serialize(values, this.allocator, this.isContinuation);
                this.isContinuation = this.isContinuation || buffer.readableBytes() > 0;
                this.delegate.write(buffer);
            }
        };
    }

    private Buffer serialize(@Nullable Map<String, List<String>> parameters, BufferAllocator allocator, boolean isContinuation) {
        if (parameters == null) {
            return EmptyBuffer.EMPTY_BUFFER;
        }
        Buffer buffer = allocator.newBuffer();
        parameters.forEach((key, values) -> {
            if (key == null || key.isEmpty()) {
                throw new SerializationException("Null or empty keys are not supported for x-www-form-urlencoded params");
            }
            if (values == null || values.isEmpty()) {
                this.writeKey(buffer, isContinuation, (String)key);
                return;
            }
            values.forEach(value -> {
                this.writeKey(buffer, isContinuation, (String)key);
                if (value != null) {
                    if (this.isOptimizedCharset) {
                        buffer.writeByte(61);
                    } else {
                        buffer.writeBytes("=".getBytes(this.charset));
                    }
                    if (!value.isEmpty()) {
                        buffer.writeBytes(this.urlEncode((String)value).getBytes(this.charset));
                    }
                }
            });
        });
        return buffer;
    }

    private void writeKey(Buffer buffer, boolean isContinuation, String key) {
        if (buffer.writerIndex() != 0 || isContinuation) {
            if (this.isOptimizedCharset) {
                buffer.writeByte(38);
            } else {
                buffer.writeBytes("&".getBytes(this.charset));
            }
        }
        buffer.writeBytes(this.urlEncode(key).getBytes(this.charset));
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

