/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.EmptyBuffer;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.BufferEncoder;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.AbstractDelegatingHttpRequest;
import io.servicetalk.http.api.BlockingStreamingHttpRequest;
import io.servicetalk.http.api.DefaultPayloadInfo;
import io.servicetalk.http.api.DefaultStreamingHttpRequest;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpDataSourceTransformations;
import io.servicetalk.http.api.HttpDeserializer2;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpSerializer2;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.TrailersTransformer;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nullable;

final class DefaultHttpRequest
extends AbstractDelegatingHttpRequest
implements HttpRequest,
TrailersTransformer<Object, Buffer> {
    private Buffer payloadBody;
    @Nullable
    private HttpHeaders trailers;

    DefaultHttpRequest(DefaultStreamingHttpRequest original, Buffer payloadBody, @Nullable HttpHeaders trailers) {
        super(original);
        this.payloadBody = payloadBody;
        this.trailers = trailers;
    }

    @Override
    public HttpRequest version(HttpProtocolVersion version) {
        this.original.version(version);
        return this;
    }

    @Override
    @Deprecated
    public HttpRequest encoding(ContentCodec encoding) {
        this.original.encoding(encoding);
        return this;
    }

    @Override
    public HttpRequest contentEncoding(@Nullable BufferEncoder encoder) {
        this.original.contentEncoding(encoder);
        return this;
    }

    @Override
    public HttpRequest method(HttpRequestMethod method) {
        this.original.method(method);
        return this;
    }

    @Override
    public HttpRequest requestTarget(String requestTarget) {
        this.original.requestTarget(requestTarget);
        return this;
    }

    @Override
    public HttpRequest requestTarget(String requestTarget, Charset encoding) {
        this.original.requestTarget(requestTarget, encoding);
        return this;
    }

    @Override
    public HttpRequest rawPath(String path) {
        this.original.rawPath(path);
        return this;
    }

    @Override
    public HttpRequest path(String path) {
        this.original.path(path);
        return this;
    }

    @Override
    public HttpRequest appendPathSegments(String ... segments) {
        this.original.appendPathSegments(segments);
        return this;
    }

    @Override
    public HttpRequest rawQuery(@Nullable String query) {
        this.original.rawQuery(query);
        return this;
    }

    @Override
    public HttpRequest query(@Nullable String query) {
        this.original.query(query);
        return this;
    }

    @Override
    public HttpRequest addQueryParameter(String key, String value) {
        this.original.addQueryParameter(key, value);
        return this;
    }

    @Override
    public HttpRequest addQueryParameters(String key, Iterable<String> values) {
        this.original.addQueryParameters(key, (Iterable)values);
        return this;
    }

    @Override
    public HttpRequest addQueryParameters(String key, String ... values) {
        this.original.addQueryParameters(key, values);
        return this;
    }

    @Override
    public HttpRequest setQueryParameter(String key, String value) {
        this.original.setQueryParameter(key, value);
        return this;
    }

    @Override
    public HttpRequest setQueryParameters(String key, Iterable<String> values) {
        this.original.setQueryParameters(key, (Iterable)values);
        return this;
    }

    @Override
    public HttpRequest setQueryParameters(String key, String ... values) {
        this.original.setQueryParameters(key, values);
        return this;
    }

    @Override
    public HttpRequest fragment(@Nullable String fragment) {
        this.original.fragment(fragment);
        return this;
    }

    @Override
    public HttpRequest addHeader(CharSequence name, CharSequence value) {
        this.original.addHeader(name, value);
        return this;
    }

    @Override
    public HttpRequest addHeaders(HttpHeaders headers) {
        this.original.addHeaders(headers);
        return this;
    }

    @Override
    public HttpRequest setHeader(CharSequence name, CharSequence value) {
        this.original.setHeader(name, value);
        return this;
    }

    @Override
    public HttpRequest setHeaders(HttpHeaders headers) {
        this.original.setHeaders(headers);
        return this;
    }

    @Override
    public HttpRequest addCookie(HttpCookiePair cookie) {
        this.original.addCookie(cookie);
        return this;
    }

    @Override
    public HttpRequest addCookie(CharSequence name, CharSequence value) {
        this.original.addCookie(name, value);
        return this;
    }

    @Override
    public HttpRequest addSetCookie(HttpSetCookie cookie) {
        this.original.addSetCookie(cookie);
        return this;
    }

    @Override
    public HttpRequest addSetCookie(CharSequence name, CharSequence value) {
        this.original.addSetCookie(name, value);
        return this;
    }

    @Override
    public HttpRequest context(ContextMap context) {
        this.original.context(context);
        return this;
    }

    @Override
    public Buffer payloadBody() {
        if (this.payloadBody == EmptyBuffer.EMPTY_BUFFER) {
            this.payloadBody = this.original.payloadHolder().allocator().newBuffer(0, false);
        }
        return this.payloadBody;
    }

    @Override
    public <T> T payloadBody(HttpDeserializer2<T> deserializer) {
        return deserializer.deserialize(this.headers(), this.original.payloadHolder().allocator(), this.payloadBody);
    }

    @Override
    public HttpRequest payloadBody(Buffer payloadBody) {
        this.payloadBody = Objects.requireNonNull(payloadBody);
        this.original.payloadBody(Publisher.from(payloadBody));
        return this;
    }

    @Override
    public <T> HttpRequest payloadBody(T pojo, HttpSerializer<T> serializer) {
        this.payloadBody = serializer.serialize(this.headers(), pojo, this.original.payloadHolder().allocator());
        this.original.payloadBody(Publisher.from(this.payloadBody));
        return this;
    }

    @Override
    public <T> HttpRequest payloadBody(T pojo, HttpSerializer2<T> serializer) {
        this.payloadBody = serializer.serialize(this.headers(), pojo, this.original.payloadHolder().allocator());
        this.original.payloadBody(Publisher.from(this.payloadBody));
        return this;
    }

    @Override
    public HttpHeaders trailers() {
        if (this.trailers == null) {
            this.trailers = this.original.payloadHolder().headersFactory().newTrailers();
            this.original.transform(this);
        }
        return this.trailers;
    }

    @Override
    public Object newState() {
        return null;
    }

    @Override
    public Buffer accept(Object __, Buffer buffer) {
        return buffer;
    }

    @Override
    public HttpHeaders payloadComplete(Object __, HttpHeaders extTrailers) {
        return this.trailers == null ? extTrailers : this.trailers;
    }

    @Override
    public HttpHeaders catchPayloadFailure(Object __, Throwable cause, HttpHeaders ___) throws Throwable {
        throw cause;
    }

    @Override
    public StreamingHttpRequest toStreamingRequest() {
        boolean emptyPayloadBody = HttpDataSourceTransformations.isAlwaysEmpty(this.payloadBody);
        Publisher<Object> payload = this.trailers != null ? (emptyPayloadBody ? Publisher.from(this.trailers) : Publisher.from(this.payloadBody, this.trailers)) : (emptyPayloadBody ? null : Publisher.from(this.payloadBody));
        DefaultPayloadInfo payloadInfo = new DefaultPayloadInfo(this).setEmpty(emptyPayloadBody).setMayHaveTrailersAndGenericTypeBuffer(this.trailers != null);
        return new DefaultStreamingHttpRequest(this.method(), this.requestTarget(), this.version(), this.headers(), this.context0(), this.encoding(), this.contentEncoding(), this.original.payloadHolder().allocator(), payload, payloadInfo, this.original.payloadHolder().headersFactory());
    }

    @Override
    public BlockingStreamingHttpRequest toBlockingStreamingRequest() {
        return this.toStreamingRequest().toBlockingStreamingRequest();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultHttpRequest that = (DefaultHttpRequest)o;
        if (!this.payloadBody.equals(that.payloadBody)) {
            return false;
        }
        return this.trailers != null ? this.trailers.equals(that.trailers) : that.trailers == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.payloadBody.hashCode();
        result = 31 * result + (this.trailers != null ? this.trailers.hashCode() : 0);
        return result;
    }
}

