/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.encoding.api.BufferDecoder;
import io.servicetalk.encoding.api.BufferDecoderGroup;
import io.servicetalk.encoding.api.BufferEncoder;
import io.servicetalk.encoding.api.EmptyBufferDecoderGroup;
import io.servicetalk.encoding.api.Identity;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ContentEncodingHttpServiceFilter
implements StreamingHttpServiceFilterFactory {
    private final BufferDecoderGroup decompressors;
    private final List<BufferEncoder> compressors;

    public ContentEncodingHttpServiceFilter(List<BufferEncoder> compressors) {
        this(compressors, EmptyBufferDecoderGroup.INSTANCE);
    }

    public ContentEncodingHttpServiceFilter(List<BufferEncoder> compressors, BufferDecoderGroup decompressors) {
        this.decompressors = Objects.requireNonNull(decompressors);
        this.compressors = Objects.requireNonNull(compressors);
    }

    @Override
    public StreamingHttpServiceFilter create(StreamingHttpService service) {
        return new StreamingHttpServiceFilter(service){

            @Override
            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                return Single.defer(() -> {
                    StreamingHttpRequest requestDecompressed;
                    Iterator<? extends CharSequence> contentEncodingItr = request.headers().valuesIterator(HttpHeaderNames.CONTENT_ENCODING);
                    boolean hasContentEncoding = contentEncodingItr.hasNext();
                    if (hasContentEncoding) {
                        BufferDecoder decoder = ContentEncodingHttpServiceFilter.matchAndRemoveEncoding(ContentEncodingHttpServiceFilter.this.decompressors.decoders(), BufferDecoder::encodingName, contentEncodingItr, request.headers());
                        if (decoder == null) {
                            return Single.succeeded(responseFactory.unsupportedMediaType()).shareContextOnSubscribe();
                        }
                        request.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
                        requestDecompressed = request.transformPayloadBody(pub -> decoder.streamingDecoder().deserialize((Publisher<Buffer>)pub, ctx.executionContext().bufferAllocator()));
                    } else {
                        requestDecompressed = request;
                    }
                    return super.handle(ctx, requestDecompressed, responseFactory).map(response -> {
                        CharSequence reqAcceptEncoding;
                        if (ContentEncodingHttpServiceFilter.isPassThrough(request.method(), response) || (reqAcceptEncoding = request.headers().get(HttpHeaderNames.ACCEPT_ENCODING)) == null) {
                            return response;
                        }
                        BufferEncoder encoder = io.servicetalk.encoding.api.internal.HeaderUtils.negotiateAcceptedEncodingRaw(reqAcceptEncoding, ContentEncodingHttpServiceFilter.this.compressors, BufferEncoder::encodingName);
                        if (encoder == null || Identity.identityEncoder().equals(encoder)) {
                            return response;
                        }
                        HeaderUtils.addContentEncoding(response.headers(), encoder.encodingName());
                        request.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
                        return response.transformPayloadBody(bufPub -> encoder.streamingEncoder().serialize((Publisher<Buffer>)bufPub, ctx.executionContext().bufferAllocator()));
                    }).shareContextOnSubscribe();
                });
            }
        };
    }

    @Override
    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    private static boolean isPassThrough(HttpRequestMethod method, StreamingHttpResponse response) {
        int code = response.status().code();
        return HttpResponseStatus.StatusClass.INFORMATIONAL_1XX.contains(code) || code == HttpResponseStatus.NO_CONTENT.code() || code == HttpResponseStatus.NOT_MODIFIED.code() || method == HttpRequestMethod.HEAD || method == HttpRequestMethod.CONNECT && HttpResponseStatus.StatusClass.SUCCESSFUL_2XX.contains(code);
    }

    @Nullable
    static <T> T matchAndRemoveEncoding(List<T> supportedEncoders, Function<T, CharSequence> messageEncodingFunc, Iterator<? extends CharSequence> contentEncodingItr, HttpHeaders headers) {
        if (supportedEncoders.isEmpty() || !contentEncodingItr.hasNext()) {
            return null;
        }
        CharSequence encoding = contentEncodingItr.next();
        int i = 0;
        int j = CharSequences.indexOf(encoding, ',', 0);
        if (j < 0) {
            j = encoding.length();
        }
        if (j == 0) {
            return null;
        }
        int jNonTrimmed = j;
        while (encoding.charAt(j - 1) == ' ') {
            if (--j != 0) continue;
            return null;
        }
        while (encoding.charAt(i) == ' ') {
            if (++i != j) continue;
            return null;
        }
        int x = 0;
        do {
            T supportedEncoding;
            CharSequence serverSupported;
            if (!CharSequences.regionMatches(encoding, true, i, serverSupported = messageEncodingFunc.apply(supportedEncoding = supportedEncoders.get(x)), 0, serverSupported.length())) continue;
            contentEncodingItr.remove();
            if (jNonTrimmed + 1 < encoding.length()) {
                ContentEncodingHttpServiceFilter.resetContentEncoding(headers, encoding.subSequence(jNonTrimmed + 1, encoding.length()));
            }
            return supportedEncoding;
        } while (++x < supportedEncoders.size());
        return null;
    }

    private static void resetContentEncoding(HttpHeaders headers, CharSequence updatedValue) {
        ArrayList<CharSequence> valuesArray = new ArrayList<CharSequence>(4);
        valuesArray.add(updatedValue);
        for (CharSequence charSequence : headers.values(HttpHeaderNames.CONTENT_ENCODING)) {
            valuesArray.add(charSequence);
        }
        headers.set(HttpHeaderNames.CONTENT_ENCODING, valuesArray);
    }
}

