/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.CloseableIteratorBufferAsInputStream;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.BufferEncoder;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMessageBodyIterable;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.http.api.HttpStreamingDeserializer;
import io.servicetalk.http.api.HttpStreamingSerializer;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.TrailersTransformer;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public interface BlockingStreamingHttpRequest
extends HttpRequestMetaData {
    public BlockingIterable<Buffer> payloadBody();

    default public InputStream payloadBodyInputStream() {
        return new CloseableIteratorBufferAsInputStream(this.payloadBody().iterator());
    }

    @Deprecated
    default public <T> BlockingIterable<T> payloadBody(HttpDeserializer<T> deserializer) {
        return deserializer.deserialize(this.headers(), this.payloadBody());
    }

    public <T> BlockingIterable<T> payloadBody(HttpStreamingDeserializer<T> var1);

    public HttpMessageBodyIterable<Buffer> messageBody();

    public <T> HttpMessageBodyIterable<T> messageBody(HttpStreamingDeserializer<T> var1);

    public BlockingStreamingHttpRequest payloadBody(Iterable<Buffer> var1);

    public BlockingStreamingHttpRequest payloadBody(InputStream var1);

    public BlockingStreamingHttpRequest messageBody(HttpMessageBodyIterable<Buffer> var1);

    @Deprecated
    default public <T> BlockingStreamingHttpRequest payloadBody(Iterable<T> payloadBody, HttpSerializer<T> serializer) {
        throw new UnsupportedOperationException("BlockingStreamingHttpRequest#payloadBody(Iterable, HttpSerializer) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to BlockingStreamingHttpRequest#payloadBody(Iterable, HttpStreamingSerializer) or implement this method if it's required temporarily.");
    }

    public <T> BlockingStreamingHttpRequest payloadBody(Iterable<T> var1, HttpStreamingSerializer<T> var2);

    public <T> BlockingStreamingHttpRequest messageBody(HttpMessageBodyIterable<T> var1, HttpStreamingSerializer<T> var2);

    @Deprecated
    default public <T> BlockingStreamingHttpRequest transformPayloadBody(Function<BlockingIterable<Buffer>, BlockingIterable<T>> transformer, HttpSerializer<T> serializer) {
        throw new UnsupportedOperationException("BlockingStreamingHttpRequest#transformPayloadBody(Function, HttpSerializer) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to alternative methods or implement this method if it's required temporarily.");
    }

    @Deprecated
    default public <T, R> BlockingStreamingHttpRequest transformPayloadBody(Function<BlockingIterable<T>, BlockingIterable<R>> transformer, HttpDeserializer<T> deserializer, HttpSerializer<R> serializer) {
        return this.transformPayloadBody(buffers -> (BlockingIterable)transformer.apply(this.payloadBody(deserializer)), serializer);
    }

    @Deprecated
    default public BlockingStreamingHttpRequest transformPayloadBody(UnaryOperator<BlockingIterable<Buffer>> transformer) {
        throw new UnsupportedOperationException("BlockingStreamingHttpRequest#transformPayloadBody(UnaryOperator) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to alternative methods or implement this method if it's required temporarily.");
    }

    @Deprecated
    default public <T> BlockingStreamingHttpRequest transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        throw new UnsupportedOperationException("BlockingStreamingHttpRequest#transform(TrailersTransformer) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to alternative methods or implement this method if it's required temporarily.");
    }

    public Single<HttpRequest> toRequest();

    public StreamingHttpRequest toStreamingRequest();

    @Override
    public BlockingStreamingHttpRequest rawPath(String var1);

    @Override
    public BlockingStreamingHttpRequest path(String var1);

    @Override
    public BlockingStreamingHttpRequest appendPathSegments(String ... var1);

    @Override
    public BlockingStreamingHttpRequest rawQuery(@Nullable String var1);

    @Override
    public BlockingStreamingHttpRequest query(@Nullable String var1);

    @Override
    public BlockingStreamingHttpRequest addQueryParameter(String var1, String var2);

    @Override
    public BlockingStreamingHttpRequest addQueryParameters(String var1, Iterable<String> var2);

    @Override
    public BlockingStreamingHttpRequest addQueryParameters(String var1, String ... var2);

    @Override
    public BlockingStreamingHttpRequest setQueryParameter(String var1, String var2);

    @Override
    public BlockingStreamingHttpRequest setQueryParameters(String var1, Iterable<String> var2);

    @Override
    public BlockingStreamingHttpRequest setQueryParameters(String var1, String ... var2);

    @Override
    public BlockingStreamingHttpRequest version(HttpProtocolVersion var1);

    @Override
    default public BlockingStreamingHttpRequest fragment(@Nullable String fragment) {
        throw new UnsupportedOperationException("BlockingStreamingHttpRequest#fragment(String) is not supported by " + this.getClass());
    }

    @Override
    @Deprecated
    default public BlockingStreamingHttpRequest encoding(ContentCodec encoding) {
        throw new UnsupportedOperationException("BlockingStreamingHttpRequest#encoding(ContentCodec) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to provided alternatives or implement this method if it's required temporarily.");
    }

    @Override
    public BlockingStreamingHttpRequest contentEncoding(@Nullable BufferEncoder var1);

    @Override
    public BlockingStreamingHttpRequest method(HttpRequestMethod var1);

    @Override
    public BlockingStreamingHttpRequest requestTarget(String var1);

    @Override
    public BlockingStreamingHttpRequest requestTarget(String var1, Charset var2);

    @Override
    default public BlockingStreamingHttpRequest addHeader(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.addHeader(name, value);
        return this;
    }

    @Override
    default public BlockingStreamingHttpRequest addHeaders(HttpHeaders headers) {
        HttpRequestMetaData.super.addHeaders(headers);
        return this;
    }

    @Override
    default public BlockingStreamingHttpRequest setHeader(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.setHeader(name, value);
        return this;
    }

    @Override
    default public BlockingStreamingHttpRequest setHeaders(HttpHeaders headers) {
        HttpRequestMetaData.super.setHeaders(headers);
        return this;
    }

    @Override
    default public BlockingStreamingHttpRequest addCookie(HttpCookiePair cookie) {
        HttpRequestMetaData.super.addCookie(cookie);
        return this;
    }

    @Override
    default public BlockingStreamingHttpRequest addCookie(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.addCookie(name, value);
        return this;
    }

    @Override
    default public BlockingStreamingHttpRequest addSetCookie(HttpSetCookie cookie) {
        HttpRequestMetaData.super.addSetCookie(cookie);
        return this;
    }

    @Override
    default public BlockingStreamingHttpRequest addSetCookie(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.addSetCookie(name, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest context(ContextMap var1);
}

