/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.api.internal;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.Identity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HeaderUtils {
    private static final List<ContentCodec> NONE_CONTENT_ENCODING_SINGLETON = Collections.singletonList(Identity.identity());

    private HeaderUtils() {
    }

    @Deprecated
    @Nullable
    public static ContentCodec negotiateAcceptedEncoding(@Nullable CharSequence acceptEncodingHeaderValue, List<ContentCodec> serverSupportedEncodings) {
        if (serverSupportedEncodings.isEmpty() || serverSupportedEncodings.size() == 1 && serverSupportedEncodings.contains(Identity.identity())) {
            return null;
        }
        List<ContentCodec> clientSupportedEncodings = HeaderUtils.parseAcceptEncoding(acceptEncodingHeaderValue, serverSupportedEncodings);
        return HeaderUtils.negotiateAcceptedEncoding(clientSupportedEncodings, serverSupportedEncodings);
    }

    @Nullable
    public static <T> T negotiateAcceptedEncodingRaw(@Nullable CharSequence acceptEncodingHeaderValue, List<T> supportedEncoders, Function<T, CharSequence> messageEncodingFunc) {
        int jNonTrimmed;
        if (acceptEncodingHeaderValue == null || supportedEncoders.isEmpty()) {
            return null;
        }
        int i = 0;
        do {
            char firstChar;
            int j;
            if ((j = CharSequences.indexOf(acceptEncodingHeaderValue, ',', i)) < 0) {
                j = acceptEncodingHeaderValue.length();
            }
            if (i >= j) {
                return null;
            }
            jNonTrimmed = j;
            while (acceptEncodingHeaderValue.charAt(j - 1) == ' ') {
                if (--j != i) continue;
                return null;
            }
            while ((firstChar = acceptEncodingHeaderValue.charAt(i)) == ' ') {
                if (++i != j) continue;
                return null;
            }
            if (firstChar == '*') {
                return supportedEncoders.get(0);
            }
            int x = 0;
            do {
                T supportedEncoding;
                CharSequence serverSupported;
                if (!CharSequences.regionMatches(acceptEncodingHeaderValue, true, i, serverSupported = messageEncodingFunc.apply(supportedEncoding = supportedEncoders.get(x)), 0, serverSupported.length())) continue;
                return supportedEncoding;
            } while (++x < supportedEncoders.size());
        } while ((i = jNonTrimmed + 1) < acceptEncodingHeaderValue.length());
        return null;
    }

    @Deprecated
    @Nullable
    public static ContentCodec negotiateAcceptedEncoding(List<ContentCodec> clientSupportedEncodings, List<ContentCodec> serverSupportedEncodings) {
        if (clientSupportedEncodings == NONE_CONTENT_ENCODING_SINGLETON || clientSupportedEncodings.size() == 1 && clientSupportedEncodings.contains(Identity.identity())) {
            return null;
        }
        for (ContentCodec encoding : serverSupportedEncodings) {
            if (Identity.identity().equals(encoding) || !clientSupportedEncodings.contains(encoding)) continue;
            return encoding;
        }
        return null;
    }

    @Deprecated
    private static List<ContentCodec> parseAcceptEncoding(@Nullable CharSequence acceptEncodingHeaderValue, List<ContentCodec> allowedEncodings) {
        if (acceptEncodingHeaderValue == null || acceptEncodingHeaderValue.length() == 0) {
            return NONE_CONTENT_ENCODING_SINGLETON;
        }
        ArrayList<ContentCodec> knownEncodings = new ArrayList<ContentCodec>();
        List<CharSequence> acceptEncodingValues = CharSequences.split(acceptEncodingHeaderValue, ',', true);
        for (CharSequence val : acceptEncodingValues) {
            ContentCodec enc = HeaderUtils.encodingFor(allowedEncodings, val);
            if (enc == null) continue;
            knownEncodings.add(enc);
        }
        return knownEncodings;
    }

    @Deprecated
    @Nullable
    public static ContentCodec encodingFor(Collection<ContentCodec> allowedList, @Nullable CharSequence name) {
        Objects.requireNonNull(allowedList);
        if (name == null || name.length() == 0) {
            return null;
        }
        if (CharSequences.contentEquals(name, Identity.identity().name())) {
            return Identity.identity();
        }
        for (ContentCodec enumEnc : allowedList) {
            if (!HeaderUtils.startsWith(name, enumEnc.name())) continue;
            return enumEnc;
        }
        return null;
    }

    @Nullable
    public static <T> T encodingForRaw(List<T> supportedEncoders, Function<T, CharSequence> messageEncodingFunc, CharSequence name) {
        for (T allowed : supportedEncoders) {
            if (!HeaderUtils.startsWith(name, messageEncodingFunc.apply(allowed))) continue;
            return allowed;
        }
        return null;
    }

    private static boolean startsWith(CharSequence string, CharSequence prefix) {
        return CharSequences.regionMatches(string, true, 0, prefix, 0, prefix.length());
    }
}

