/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.servicetalk.dns.discovery.netty.DefaultDnsServiceDiscovererBuilder;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererBuilder;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererBuilderProvider;
import io.servicetalk.utils.internal.ServiceLoaderUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DnsServiceDiscoverers {
    private static final Logger LOGGER = LoggerFactory.getLogger(DnsServiceDiscoverers.class);
    private static final List<DnsServiceDiscovererBuilderProvider> PROVIDERS;

    private DnsServiceDiscoverers() {
    }

    private static DnsServiceDiscovererBuilder applyProviders(String id, DnsServiceDiscovererBuilder builder) {
        for (DnsServiceDiscovererBuilderProvider provider : PROVIDERS) {
            builder = provider.newBuilder(id, builder);
        }
        return builder;
    }

    public static DnsServiceDiscovererBuilder builder(String id) {
        return DnsServiceDiscoverers.applyProviders(id, new DefaultDnsServiceDiscovererBuilder(id));
    }

    static {
        ClassLoader classLoader = DnsServiceDiscoverers.class.getClassLoader();
        PROVIDERS = ServiceLoaderUtils.loadProviders(DnsServiceDiscovererBuilderProvider.class, classLoader, LOGGER);
    }
}

