/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DnsNameResolverBuilderUtils {
    private static final Logger LOGGER;
    private static final String NETTY_VERSION;
    @Nullable
    private static final MethodHandle CONSOLIDATE_CACHE_SIZE;

    private DnsNameResolverBuilderUtils() {
    }

    private static DnsNameResolverBuilder consolidateCacheSize(MethodHandle consolidateCacheSize, DnsNameResolverBuilder builder, int maxNumConsolidation) {
        try {
            return consolidateCacheSize.invokeExact(builder, maxNumConsolidation);
        }
        catch (Throwable t) {
            ThrowableUtils.throwException(t);
            return builder;
        }
    }

    static void consolidateCacheSize(String id, DnsNameResolverBuilder builder, int maxNumConsolidation) {
        if (CONSOLIDATE_CACHE_SIZE == null) {
            if (maxNumConsolidation != 1024) {
                LOGGER.warn("consolidateCacheSize({}) can not be applied for a new DNS ServiceDiscoverer '{}' because io.netty.resolver.dns.DnsNameResolverBuilder#consolidateCacheSize(int) method is not available in Netty {}, expected Netty version is 4.1.88.Final or later.", maxNumConsolidation, id, NETTY_VERSION);
            }
            return;
        }
        DnsNameResolverBuilderUtils.consolidateCacheSize(CONSOLIDATE_CACHE_SIZE, builder, maxNumConsolidation);
    }

    static {
        MethodHandle consolidateCacheSize;
        LOGGER = LoggerFactory.getLogger(DnsNameResolverBuilderUtils.class);
        NETTY_VERSION = DnsNameResolverBuilder.class.getPackage().getImplementationVersion();
        try {
            consolidateCacheSize = MethodHandles.publicLookup().findVirtual(DnsNameResolverBuilder.class, "consolidateCacheSize", MethodType.methodType(DnsNameResolverBuilder.class, Integer.TYPE));
            DnsNameResolverBuilderUtils.consolidateCacheSize(consolidateCacheSize, new DnsNameResolverBuilder(), 1);
        }
        catch (Throwable cause) {
            LOGGER.debug("DnsNameResolverBuilder#consolidateCacheSize(int) is available only starting from Netty 4.1.88.Final. Detected Netty version: {}", (Object)NETTY_VERSION, (Object)cause);
            consolidateCacheSize = null;
        }
        CONSOLIDATE_CACHE_SIZE = consolidateCacheSize;
    }
}

