/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.Cancellable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

public final class ThreadInterruptingCancellable
implements Cancellable {
    private static final AtomicReferenceFieldUpdater<ThreadInterruptingCancellable, Object> threadUpdater = AtomicReferenceFieldUpdater.newUpdater(ThreadInterruptingCancellable.class, Object.class, "thread");
    private static final Object CANCELLED = new Object();
    private static final Object DONE = new Object();
    @Nullable
    private volatile Object thread;

    public ThreadInterruptingCancellable(Thread threadToInterrupt) {
        if (!threadUpdater.compareAndSet(this, null, Objects.requireNonNull(threadToInterrupt))) {
            this.handleInitFail(threadToInterrupt);
        }
    }

    private void handleInitFail(Thread threadToInterrupt) {
        if (this.thread == CANCELLED) {
            threadToInterrupt.interrupt();
        }
    }

    @Override
    public void cancel() {
        Object currThread = threadUpdater.getAndAccumulate(this, CANCELLED, (prev, x) -> prev == DONE ? DONE : CANCELLED);
        if (currThread instanceof Thread) {
            ((Thread)currThread).interrupt();
        }
    }

    public void setDone() {
        this.thread = DONE;
    }

    public void setDone(Throwable cause) {
        this.setDone();
        if (cause instanceof InterruptedException) {
            Thread.interrupted();
        }
    }
}

