/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.internal.ContextMapUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DefaultContextMap
implements ContextMap {
    private final HashMap<ContextMap.Key<?>, Object> theMap;

    public DefaultContextMap() {
        this.theMap = new HashMap(4);
    }

    private DefaultContextMap(DefaultContextMap other) {
        this.theMap = new HashMap(other.theMap);
    }

    @Override
    public int size() {
        return this.theMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    @Override
    public boolean containsKey(ContextMap.Key<?> key) {
        return this.theMap.containsKey(Objects.requireNonNull(key, "key"));
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.theMap.containsValue(value);
    }

    @Override
    @Nullable
    public <T> T get(ContextMap.Key<T> key) {
        return (T)this.theMap.get(Objects.requireNonNull(key, "key"));
    }

    @Override
    @Nullable
    public <T> T getOrDefault(ContextMap.Key<T> key, T defaultValue) {
        return (T)this.theMap.getOrDefault(Objects.requireNonNull(key, "key"), defaultValue);
    }

    @Override
    @Nullable
    public <T> T put(ContextMap.Key<T> key, @Nullable T value) {
        return (T)this.theMap.put(Objects.requireNonNull(key, "key"), value);
    }

    @Override
    @Nullable
    public <T> T putIfAbsent(ContextMap.Key<T> key, @Nullable T value) {
        return (T)this.theMap.putIfAbsent(Objects.requireNonNull(key, "key"), value);
    }

    @Override
    @Nullable
    public <T> T computeIfAbsent(ContextMap.Key<T> key, Function<ContextMap.Key<T>, T> computeFunction) {
        return (T)this.theMap.computeIfAbsent(Objects.requireNonNull(key, "key"), (? super K k) -> computeFunction.apply((ContextMap.Key)k));
    }

    @Override
    public void putAll(ContextMap map) {
        if (map instanceof DefaultContextMap) {
            DefaultContextMap dcm = (DefaultContextMap)map;
            this.theMap.putAll(dcm.theMap);
        } else {
            ContextMap.super.putAll(map);
        }
    }

    @Override
    public void putAll(Map<ContextMap.Key<?>, Object> map) {
        map.forEach(ContextMapUtils::ensureType);
        this.theMap.putAll(map);
    }

    @Override
    @Nullable
    public <T> T remove(ContextMap.Key<T> key) {
        return (T)this.theMap.remove(Objects.requireNonNull(key, "key"));
    }

    @Override
    public void clear() {
        this.theMap.clear();
    }

    @Override
    @Nullable
    public ContextMap.Key<?> forEach(BiPredicate<ContextMap.Key<?>, Object> consumer) {
        for (Map.Entry<ContextMap.Key<?>, Object> entry : this.theMap.entrySet()) {
            if (consumer.test(entry.getKey(), entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public ContextMap copy() {
        return new DefaultContextMap(this);
    }

    @Override
    public int hashCode() {
        return this.theMap.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextMap)) {
            return false;
        }
        if (o instanceof DefaultContextMap) {
            return this.theMap.equals(((DefaultContextMap)o).theMap);
        }
        return ContextMapUtils.equals(this, (ContextMap)o);
    }

    public String toString() {
        return ContextMapUtils.toString(this);
    }
}

