/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.CloseableIterable;
import io.servicetalk.concurrent.CloseableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public final class BlockingIterables {
    private BlockingIterables() {
    }

    public static <T> BlockingIterable<T> emptyBlockingIterable() {
        return EmptyBlockingIterable.INSTANCE;
    }

    public static <T> BlockingIterable<T> singletonBlockingIterable(T item) {
        return new SingletonBlockingIterable<T>(item);
    }

    public static <T> BlockingIterable<T> from(final Iterable<T> iterable) {
        if (iterable instanceof BlockingIterable) {
            return (BlockingIterable)iterable;
        }
        return () -> new BlockingIterator<T>(){
            private final Iterator itr;
            {
                this.itr = iterable.iterator();
            }

            @Override
            public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                return this.hasNext();
            }

            @Override
            @Nullable
            public T next(long timeout, TimeUnit unit) throws TimeoutException {
                return this.itr.next();
            }

            @Override
            @Nullable
            public T next() {
                return this.itr.next();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }
        };
    }

    public static <T> BlockingIterable<T> from(final CloseableIterable<T> iterable) {
        if (iterable instanceof BlockingIterable) {
            return (BlockingIterable)iterable;
        }
        return () -> new BlockingIterator<T>(){
            private final CloseableIterator itr;
            {
                this.itr = iterable.iterator();
            }

            @Override
            public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                return this.hasNext();
            }

            @Override
            @Nullable
            public T next(long timeout, TimeUnit unit) throws TimeoutException {
                return this.itr.next();
            }

            @Override
            @Nullable
            public T next() {
                return this.itr.next();
            }

            @Override
            public void close() throws Exception {
                this.itr.close();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }
        };
    }

    private static final class SingletonBlockingIterable<T>
    implements BlockingIterable<T> {
        @Nullable
        private final T item;

        SingletonBlockingIterable(T item) {
            this.item = item;
        }

        @Override
        public BlockingIterator<T> iterator() {
            return new SingletonBlockingIterator<T>(this.item);
        }

        private static final class SingletonBlockingIterator<T>
        implements BlockingIterator<T> {
            @Nullable
            private final T item;
            private boolean hasNext = true;

            SingletonBlockingIterator(@Nullable T item) {
                this.item = item;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return this.item;
            }

            @Override
            public boolean hasNext(long timeout, TimeUnit unit) {
                return this.hasNext;
            }

            @Override
            @Nullable
            public T next(long timeout, TimeUnit unit) {
                return this.next();
            }

            @Override
            public void close() {
            }
        }
    }

    private static final class EmptyBlockingIterable<T>
    implements BlockingIterable<T> {
        static final BlockingIterable<?> INSTANCE = new EmptyBlockingIterable();

        private EmptyBlockingIterable() {
        }

        @Override
        public BlockingIterator<T> iterator() {
            return EmptyBlockingIterator.instance();
        }

        private static final class EmptyBlockingIterator<T>
        implements BlockingIterator<T> {
            private static final BlockingIterator<?> INSTANCE = new EmptyBlockingIterator();

            private EmptyBlockingIterator() {
            }

            public static <T> BlockingIterator<T> instance() {
                return INSTANCE;
            }

            @Override
            public boolean hasNext(long timeout, TimeUnit unit) {
                return false;
            }

            @Override
            @Nullable
            public T next(long timeout, TimeUnit unit) {
                throw new NoSuchElementException();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }
        }
    }
}

