/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.OnSubscribeIgnoringSubscriberForOffloading;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.ScanMapper;
import io.servicetalk.concurrent.api.ScanWithMapper;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class ScanWithPublisher<T, R>
extends AbstractNoHandleSubscribePublisher<R> {
    private final Publisher<T> original;
    private final Supplier<? extends ScanMapper<? super T, ? extends R>> mapperSupplier;

    ScanWithPublisher(Publisher<T> original, Supplier<R> initial, BiFunction<R, ? super T, R> accumulator) {
        this(new SupplierScanWithMapper<T, R>(initial, accumulator), original);
    }

    ScanWithPublisher(Publisher<T> original, Supplier<? extends ScanWithMapper<? super T, ? extends R>> mapperSupplier) {
        this(new SupplierScanMapper(mapperSupplier), original);
    }

    ScanWithPublisher(Supplier<? extends ScanMapper<? super T, ? extends R>> mapperSupplier, Publisher<T> original) {
        this.mapperSupplier = Objects.requireNonNull(mapperSupplier);
        this.original = original;
    }

    @Override
    ContextMap contextForSubscribe(AsyncContextProvider provider) {
        return provider.context();
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super R> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ScanWithSubscriber<T, R>(subscriber, this.mapperSupplier.get(), contextProvider, contextMap), contextMap, contextProvider);
    }

    private static final class FixedMappedTerminal<R>
    implements ScanMapper.MappedTerminal<R> {
        @Nullable
        private final R onNext;

        private FixedMappedTerminal(@Nullable R onNext) {
            this.onNext = onNext;
        }

        @Override
        @Nullable
        public R onNext() {
            return this.onNext;
        }

        @Override
        public boolean onNextValid() {
            return true;
        }

        @Override
        @Nullable
        public Throwable terminal() {
            return null;
        }
    }

    static class ScanMapperAdapter<T, R, X extends ScanWithMapper<? super T, ? extends R>>
    implements ScanMapper<T, R> {
        final X mapper;

        ScanMapperAdapter(X mapper) {
            this.mapper = (ScanWithMapper)Objects.requireNonNull(mapper);
        }

        @Override
        @Nullable
        public R mapOnNext(@Nullable T next) {
            return this.mapper.mapOnNext(next);
        }

        @Override
        @Nullable
        public ScanMapper.MappedTerminal<R> mapOnError(Throwable cause) throws Throwable {
            return this.mapper.mapTerminal() ? new FixedMappedTerminal(this.mapper.mapOnError(cause)) : null;
        }

        @Override
        @Nullable
        public ScanMapper.MappedTerminal<R> mapOnComplete() {
            return this.mapper.mapTerminal() ? new FixedMappedTerminal(this.mapper.mapOnComplete()) : null;
        }
    }

    private static final class SupplierScanWithMapper<T, R>
    implements Supplier<ScanMapper<T, R>> {
        private final BiFunction<R, ? super T, R> accumulator;
        private final Supplier<R> initial;

        SupplierScanWithMapper(Supplier<R> initial, BiFunction<R, ? super T, R> accumulator) {
            this.initial = Objects.requireNonNull(initial);
            this.accumulator = Objects.requireNonNull(accumulator);
        }

        @Override
        public ScanMapper<T, R> get() {
            return new ScanMapper<T, R>(){
                @Nullable
                private R state;
                {
                    this.state = initial.get();
                }

                @Override
                public R mapOnNext(@Nullable T next) {
                    this.state = accumulator.apply(this.state, next);
                    return this.state;
                }

                @Override
                @Nullable
                public ScanMapper.MappedTerminal<R> mapOnError(Throwable cause) {
                    return null;
                }

                @Override
                @Nullable
                public ScanMapper.MappedTerminal<R> mapOnComplete() {
                    return null;
                }
            };
        }
    }

    private static final class SupplierScanMapper<T, R>
    implements Supplier<ScanMapper<T, R>> {
        private final Supplier<? extends ScanWithMapper<? super T, ? extends R>> mapperSupplier;

        SupplierScanMapper(Supplier<? extends ScanWithMapper<? super T, ? extends R>> mapperSupplier) {
            this.mapperSupplier = Objects.requireNonNull(mapperSupplier);
        }

        @Override
        public ScanMapper<T, R> get() {
            return new ScanMapperAdapter(this.mapperSupplier.get());
        }
    }

    static class ScanWithSubscriber<T, R>
    implements PublisherSource.Subscriber<T> {
        private static final AtomicLongFieldUpdater<ScanWithSubscriber> demandUpdater = AtomicLongFieldUpdater.newUpdater(ScanWithSubscriber.class, "demand");
        private static final long TERMINATED = Long.MIN_VALUE;
        private static final long TERMINAL_PENDING = -9223372036854775807L;
        private static final long INVALID_DEMAND = -1L;
        private final PublisherSource.Subscriber<? super R> subscriber;
        private final ContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        private final ScanMapper<? super T, ? extends R> mapper;
        private volatile long demand;
        @Nullable
        private ScanMapper.MappedTerminal<? extends R> mappedTerminal;

        ScanWithSubscriber(PublisherSource.Subscriber<? super R> subscriber, ScanMapper<? super T, ? extends R> mapper, AsyncContextProvider contextProvider, ContextMap contextMap) {
            this.subscriber = subscriber;
            this.contextProvider = contextProvider;
            this.contextMap = contextMap;
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.subscriber.onSubscribe(this.newSubscription(subscription));
        }

        private PublisherSource.Subscription newSubscription(final PublisherSource.Subscription subscription) {
            return new PublisherSource.Subscription(){

                @Override
                public void request(long n) {
                    if (!SubscriberUtils.isRequestNValid(n)) {
                        this.handleInvalidDemand(n);
                    } else if (demandUpdater.getAndAccumulate(this, n, FlowControlUtils::addWithOverflowProtectionIfNotNegative) == -9223372036854775807L) {
                        demand = Long.MIN_VALUE;
                        assert (mappedTerminal != null);
                        this.deliverAllTerminalFromSubscription(mappedTerminal, this.newOffloadedSubscriber());
                    } else {
                        subscription.request(n);
                    }
                }

                @Override
                public void cancel() {
                    subscription.cancel();
                    this.onCancel();
                }

                private void handleInvalidDemand(long n) {
                    if (demandUpdater.getAndSet(this, -1L) == -9223372036854775807L) {
                        demand = Long.MIN_VALUE;
                        this.newOffloadedSubscriber().onError(SubscriberUtils.newExceptionForInvalidRequestN(n));
                    } else {
                        subscription.request(n);
                    }
                }

                private PublisherSource.Subscriber<? super R> newOffloadedSubscriber() {
                    return OnSubscribeIgnoringSubscriberForOffloading.wrapWithDummyOnSubscribe(subscriber, contextMap, contextProvider);
                }
            };
        }

        @Override
        public void onNext(@Nullable T t) {
            R mapped = this.mapper.mapOnNext(t);
            demandUpdater.decrementAndGet(this);
            this.subscriber.onNext(mapped);
        }

        @Override
        public void onError(Throwable t) {
            this.onError0(t);
        }

        @Override
        public void onComplete() {
            this.onComplete0();
        }

        protected boolean onError0(Throwable t) {
            try {
                this.mappedTerminal = this.mapper.mapOnError(t);
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return true;
            }
            if (this.mappedTerminal != null) {
                return this.deliverAllTerminal(this.mappedTerminal, this.subscriber, t);
            }
            this.demand = Long.MIN_VALUE;
            this.subscriber.onError(t);
            return true;
        }

        protected boolean onComplete0() {
            try {
                this.mappedTerminal = this.mapper.mapOnComplete();
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return true;
            }
            if (this.mappedTerminal != null) {
                return this.deliverAllTerminal(this.mappedTerminal, this.subscriber, null);
            }
            this.demand = Long.MIN_VALUE;
            this.subscriber.onComplete();
            return true;
        }

        protected void onCancel() {
        }

        protected void deliverAllTerminalFromSubscription(ScanMapper.MappedTerminal<? extends R> mappedTerminal, PublisherSource.Subscriber<? super R> subscriber) {
            this.deliverOnNextAndTerminal(mappedTerminal, subscriber);
        }

        private boolean deliverAllTerminal(ScanMapper.MappedTerminal<? extends R> mappedTerminal, PublisherSource.Subscriber<? super R> subscriber, @Nullable Throwable originalCause) {
            block6: {
                boolean onNextValid;
                try {
                    onNextValid = mappedTerminal.onNextValid();
                }
                catch (Throwable cause) {
                    subscriber.onError(cause);
                    return true;
                }
                if (onNextValid) {
                    long currDemand;
                    do {
                        if ((currDemand = this.demand) > 0L && demandUpdater.compareAndSet(this, currDemand, Long.MIN_VALUE)) {
                            this.deliverOnNextAndTerminal(mappedTerminal, subscriber);
                            break block6;
                        }
                        if (currDemand != 0L || !demandUpdater.compareAndSet(this, currDemand, -9223372036854775807L)) continue;
                        return false;
                    } while (currDemand >= 0L);
                    subscriber.onError(originalCause != null ? originalCause : new IllegalStateException("onComplete with invalid demand: " + currDemand));
                } else {
                    this.demand = Long.MIN_VALUE;
                    this.deliverTerminal(mappedTerminal, subscriber);
                }
            }
            return true;
        }

        private void deliverTerminal(ScanMapper.MappedTerminal<? extends R> mappedTerminal, PublisherSource.Subscriber<? super R> subscriber) {
            Throwable cause;
            try {
                cause = mappedTerminal.terminal();
            }
            catch (Throwable cause2) {
                subscriber.onError(cause2);
                return;
            }
            if (cause == null) {
                subscriber.onComplete();
            } else {
                subscriber.onError(cause);
            }
        }

        private void deliverOnNextAndTerminal(ScanMapper.MappedTerminal<? extends R> mappedTerminal, PublisherSource.Subscriber<? super R> subscriber) {
            try {
                assert (mappedTerminal.onNextValid());
                subscriber.onNext(mappedTerminal.onNext());
            }
            catch (Throwable cause) {
                subscriber.onError(cause);
                return;
            }
            this.deliverTerminal(mappedTerminal, subscriber);
        }
    }
}

