/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.SubscriberApiUtils;
import io.servicetalk.concurrent.api.ThrowableWrapper;
import io.servicetalk.concurrent.internal.ConcurrentUtils;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;

final class PublisherFlatMapConcatUtils {
    private PublisherFlatMapConcatUtils() {
    }

    static <T, R> Publisher<R> flatMapConcatSingle(Publisher<T> publisher, Function<? super T, ? extends Single<? extends R>> mapper) {
        return Publisher.defer(() -> publisher.flatMapMergeSingle(new OrderedMapper(mapper, PlatformDependent.newUnboundedSpscQueue(4))).shareContextOnSubscribe());
    }

    static <T, R> Publisher<R> flatMapConcatSingleDelayError(Publisher<T> publisher, Function<? super T, ? extends Single<? extends R>> mapper) {
        return Publisher.defer(() -> publisher.flatMapMergeSingleDelayError(new OrderedMapper(mapper, PlatformDependent.newUnboundedSpscQueue(4))).shareContextOnSubscribe());
    }

    static <T, R> Publisher<R> flatMapConcatSingle(Publisher<T> publisher, Function<? super T, ? extends Single<? extends R>> mapper, int maxConcurrency) {
        return Publisher.defer(() -> publisher.flatMapMergeSingle(new OrderedMapper(mapper, PlatformDependent.newUnboundedSpscQueue(Math.min(8, maxConcurrency))), maxConcurrency).shareContextOnSubscribe());
    }

    static <T, R> Publisher<R> flatMapConcatSingleDelayError(Publisher<T> publisher, Function<? super T, ? extends Single<? extends R>> mapper, int maxConcurrency) {
        return Publisher.defer(() -> publisher.flatMapMergeSingleDelayError(new OrderedMapper(mapper, PlatformDependent.newUnboundedSpscQueue(Math.min(8, maxConcurrency))), maxConcurrency).shareContextOnSubscribe());
    }

    private static final class Item<R> {
        @Nullable
        SingleSource.Subscriber<? super R> subscriber;
        @Nullable
        private Object result;

        private Item() {
        }

        void onError(Throwable cause) {
            this.result = new ThrowableWrapper(cause);
        }

        void onSuccess(@Nullable R r) {
            this.result = SubscriberApiUtils.wrapNull(r);
        }

        boolean tryTerminate() {
            Object localResult = this.result;
            if (localResult == null) {
                return false;
            }
            if (ThrowableWrapper.class.equals(localResult.getClass())) {
                assert (this.subscriber != null);
                this.subscriber.onError(((ThrowableWrapper)localResult).unwrap());
            } else {
                assert (this.subscriber != null);
                this.subscriber.onSuccess(SubscriberApiUtils.unwrapNullUnchecked(localResult));
            }
            return true;
        }
    }

    private static final class OrderedMapper<T, R>
    implements Function<T, Single<R>> {
        private static final AtomicIntegerFieldUpdater<OrderedMapper> consumerLockUpdater = AtomicIntegerFieldUpdater.newUpdater(OrderedMapper.class, "consumerLock");
        private final Function<? super T, ? extends Single<? extends R>> mapper;
        private final Queue<Item<R>> results;
        private volatile int consumerLock;

        private OrderedMapper(Function<? super T, ? extends Single<? extends R>> mapper, Queue<Item<R>> results) {
            this.mapper = mapper;
            this.results = results;
        }

        @Override
        public Single<R> apply(T t) {
            final Single<? extends R> single = this.mapper.apply(t);
            final Item item = new Item();
            this.results.add(item);
            return new Single<R>(){

                @Override
                protected void handleSubscribe(final SingleSource.Subscriber<? super R> subscriber) {
                    assert (item.subscriber == null);
                    item.subscriber = subscriber;
                    SourceAdapters.toSource(single).subscribe(new SingleSource.Subscriber<R>(){

                        @Override
                        public void onSubscribe(Cancellable cancellable) {
                            subscriber.onSubscribe(cancellable);
                        }

                        @Override
                        public void onSuccess(@Nullable R result) {
                            item.onSuccess(result);
                            this.tryPollQueue();
                        }

                        @Override
                        public void onError(Throwable t) {
                            item.onError(t);
                            this.tryPollQueue();
                        }

                        private void tryPollQueue() {
                            boolean tryAcquire = true;
                            while (tryAcquire && ConcurrentUtils.tryAcquireLock(consumerLockUpdater, this)) {
                                try {
                                    Item i;
                                    while ((i = (Item)results.peek()) != null && i.tryTerminate()) {
                                        results.poll();
                                    }
                                }
                                catch (Throwable throwable) {
                                    tryAcquire = !ConcurrentUtils.releaseLock(consumerLockUpdater, this);
                                    throw throwable;
                                }
                                tryAcquire = !ConcurrentUtils.releaseLock(consumerLockUpdater, this);
                            }
                        }
                    });
                }
            }.shareContextOnSubscribe();
        }
    }
}

