/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FutureToSingle<T>
extends Single<T>
implements SingleSource<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FutureToSingle.class);
    private final Future<? extends T> future;

    FutureToSingle(Future<? extends T> future) {
        this.future = Objects.requireNonNull(future);
    }

    @Override
    protected void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        T value;
        try {
            subscriber.onSubscribe(() -> this.future.cancel(true));
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, t);
            return;
        }
        try {
            value = this.future.get();
        }
        catch (Throwable cause) {
            subscriber.onError(cause);
            return;
        }
        try {
            subscriber.onSuccess(value);
        }
        catch (Throwable t) {
            LOGGER.info("Ignoring exception from onSuccess of Subscriber {}.", (Object)subscriber, (Object)t);
        }
    }

    @Override
    public void subscribe(SingleSource.Subscriber<? super T> subscriber) {
        this.subscribeInternal(subscriber);
    }
}

