/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api.internal.partition;

import io.servicetalk.client.api.internal.partition.DefaultPartitionAttributesBuilder;
import io.servicetalk.client.api.partition.PartitionAttributes;
import io.servicetalk.client.api.partition.PartitionAttributesBuilder;
import io.servicetalk.client.api.partition.PartitionMap;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;

@Deprecated
public final class PowerSetPartitionMap<T extends AsyncCloseable>
implements PartitionMap<T> {
    private static final byte CLOSED_GRACEFULLY = 1;
    private static final byte HARD_CLOSE = 2;
    private static final int MAX_PARTITION_ATTRIBUTE_SIZE = 15;
    private final Function<PartitionAttributes, T> valueFactory;
    private final IntFunction<PartitionAttributesBuilder> partitionAttributesBuilderFunc;
    private final Map<PartitionAttributes, Set<PartitionAttributes>> absoluteToWildCardIndexMap;
    private volatile Map<PartitionAttributes, ValueHolder<T>> wildCardToValueMap;
    private volatile byte closed;
    private final ListenableAsyncCloseable asyncCloseable = AsyncCloseables.toAsyncCloseable(graceful -> {
        this.closed = (byte)(graceful ? 1 : 2);
        return this.closeAllValues(this.wildCardToValueMap, graceful);
    });

    PowerSetPartitionMap(Function<PartitionAttributes, T> valueFactory) {
        this(valueFactory, DefaultPartitionAttributesBuilder::new);
    }

    public PowerSetPartitionMap(Function<PartitionAttributes, T> valueFactory, IntFunction<PartitionAttributesBuilder> partitionAttributesBuilderFunc) {
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.partitionAttributesBuilderFunc = Objects.requireNonNull(partitionAttributesBuilderFunc);
        this.absoluteToWildCardIndexMap = new HashMap<PartitionAttributes, Set<PartitionAttributes>>();
        this.wildCardToValueMap = Collections.emptyMap();
    }

    @Override
    public T get(@Nullable PartitionAttributes wildCardAttributes) {
        ValueHolder<T> valueHolder = this.wildCardToValueMap.get(wildCardAttributes);
        return (T)(valueHolder == null ? null : (AsyncCloseable)valueHolder.value);
    }

    @Override
    public List<T> add(PartitionAttributes partition) {
        int partitionSize = partition.size();
        if (partitionSize <= 0 || partitionSize > 15) {
            throw new IllegalArgumentException("attribute size: " + partitionSize + " must be in the range [0," + 15 + ")");
        }
        HashMap<PartitionAttributes, ValueHolder<T>> newWildCardToAttributes = new HashMap<PartitionAttributes, ValueHolder<T>>(this.wildCardToValueMap);
        ArrayList entries = new ArrayList(partitionSize << 1);
        partition.forEach((key, value) -> {
            entries.add(key);
            entries.add(value);
        });
        int numCombinations = 1 << partitionSize;
        ArrayList effectedPartitions = new ArrayList(numCombinations);
        for (int i = 1; i < numCombinations; ++i) {
            int entriesIndex;
            PartitionAttributesBuilder wildCardAttributesBuilder = this.partitionAttributesBuilderFunc.apply(Integer.bitCount(i));
            int remainingBits = i;
            do {
                entriesIndex = Integer.numberOfTrailingZeros(remainingBits);
                wildCardAttributesBuilder.add((PartitionAttributes.Key)entries.get(entriesIndex << 1), entries.get((entriesIndex << 1) + 1));
            } while ((remainingBits &= ~(1 << entriesIndex)) != 0);
            PartitionAttributes wildCardAttributes = wildCardAttributesBuilder.build();
            ValueHolder<T> valueHolder = (ValueHolder<T>)newWildCardToAttributes.get(wildCardAttributes);
            if (valueHolder != null) {
                ++valueHolder.refCount;
            } else {
                valueHolder = new ValueHolder<T>(this.valueFactory.apply(wildCardAttributes));
                newWildCardToAttributes.put(wildCardAttributes, valueHolder);
            }
            this.absoluteToWildCardIndexMap.computeIfAbsent(partition, attributes -> new HashSet(2)).add(wildCardAttributes);
            effectedPartitions.add(valueHolder.value);
        }
        this.wildCardToValueMap = newWildCardToAttributes;
        if (this.closed > 0) {
            this.closeAllValues(newWildCardToAttributes, this.closed == 1).subscribe();
        }
        return effectedPartitions;
    }

    @Override
    public List<T> remove(PartitionAttributes partition) {
        Set<PartitionAttributes> removedWildCardAttributes = this.absoluteToWildCardIndexMap.remove(partition);
        if (removedWildCardAttributes == null) {
            return Collections.emptyList();
        }
        HashMap<PartitionAttributes, ValueHolder<T>> newWildCardToAttributes = new HashMap<PartitionAttributes, ValueHolder<T>>(this.wildCardToValueMap);
        ArrayList effectedPartitions = new ArrayList(removedWildCardAttributes.size());
        for (PartitionAttributes wildCardAttribute : removedWildCardAttributes) {
            ValueHolder valueHolder = (ValueHolder)newWildCardToAttributes.get(wildCardAttribute);
            assert (valueHolder != null);
            if (--valueHolder.refCount == 0) {
                newWildCardToAttributes.remove(wildCardAttribute);
            }
            effectedPartitions.add(valueHolder.value);
        }
        this.wildCardToValueMap = newWildCardToAttributes;
        return effectedPartitions;
    }

    @Override
    public Completable onClose() {
        return this.asyncCloseable.onClose();
    }

    @Override
    public Completable onClosing() {
        return this.asyncCloseable.onClosing();
    }

    @Override
    public Completable closeAsync() {
        return this.asyncCloseable.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.asyncCloseable.closeAsyncGracefully();
    }

    private Completable closeAllValues(Map<PartitionAttributes, ValueHolder<T>> wildCardToValueMap, boolean graceful) {
        ArrayList completables = new ArrayList(wildCardToValueMap.size());
        wildCardToValueMap.forEach((attributes, holder) -> completables.add(graceful ? ((AsyncCloseable)holder.value).closeAsyncGracefully() : ((AsyncCloseable)holder.value).closeAsync()));
        return Completable.completed().mergeDelayError(completables);
    }

    boolean isEmpty() {
        return this.absoluteToWildCardIndexMap.isEmpty() && this.wildCardToValueMap.isEmpty();
    }

    int size() {
        return this.absoluteToWildCardIndexMap.size();
    }

    int wildCardIndexSize() {
        return this.wildCardToValueMap.size();
    }

    private static final class ValueHolder<T> {
        final T value;
        int refCount;

        ValueHolder(T value) {
            this.value = Objects.requireNonNull(value);
            this.refCount = 1;
        }

        public boolean equals(Object o) {
            return this.value.equals(o);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

