/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.servicetalk.transport.netty.internal.OverlappingCapacityAwareEstimator;

final class EWMAWriteDemandEstimator
extends OverlappingCapacityAwareEstimator {
    private static final double WEIGHT_NEW = 0.2;
    private static final double WEIGHT_HISTORICAL = 0.8;
    private long sizeAccumulator;

    EWMAWriteDemandEstimator() {
        this(1024L);
    }

    EWMAWriteDemandEstimator(long sizeAccumulator) {
        super(OverlappingCapacityAwareEstimator.SizeEstimator.defaultEstimator());
        if (sizeAccumulator <= 0L) {
            throw new IllegalArgumentException("sizeAccumulator: " + sizeAccumulator + " (expected >0)");
        }
        this.sizeAccumulator = sizeAccumulator;
    }

    @Override
    protected void recordSize(Object written, long sizeInBytes) {
        this.sizeAccumulator = Math.max((long)(0.2 * (double)sizeInBytes + 0.8 * (double)this.sizeAccumulator), 1L);
    }

    @Override
    protected long getRequestNForCapacity(long capacityToFill) {
        return capacityToFill / this.sizeAccumulator;
    }
}

