/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.serializer.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.utils.internal.CharsetUtils;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

abstract class AbstractStringSerializer
implements SerializerDeserializer<String> {
    private static final Map<Charset, Integer> MAX_BYTES_PER_CHAR_MAP;
    private final Charset charset;
    private final int maxBytesPerChar;

    AbstractStringSerializer(Charset charset) {
        this.charset = charset;
        this.maxBytesPerChar = MAX_BYTES_PER_CHAR_MAP.getOrDefault(charset, 1);
    }

    @Override
    public final String deserialize(Buffer serializedData, BufferAllocator allocator) {
        String result = serializedData.toString(this.charset);
        serializedData.skipBytes(serializedData.readableBytes());
        return result;
    }

    @Override
    public final Buffer serialize(String toSerialize, BufferAllocator allocator) {
        Buffer buffer = allocator.newBuffer(toSerialize.length() * this.maxBytesPerChar);
        this.serialize(toSerialize, allocator, buffer);
        return buffer;
    }

    @Override
    public void serialize(String toSerialize, BufferAllocator allocator, Buffer buffer) {
        buffer.writeCharSequence(toSerialize, this.charset);
    }

    static {
        Collection<Charset> charsets = CharsetUtils.standardCharsets();
        MAX_BYTES_PER_CHAR_MAP = new HashMap<Charset, Integer>(charsets.size());
        for (Charset charset : charsets) {
            try {
                MAX_BYTES_PER_CHAR_MAP.put(charset, (int)charset.newEncoder().maxBytesPerChar());
            }
            catch (Throwable throwable) {}
        }
    }
}

