/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.slf4j.internal.FixedLevelLogger;
import io.servicetalk.logging.slf4j.internal.Slf4jFixedLevelLoggers;
import io.servicetalk.transport.api.ConnectionInfo;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class LoggingHttpLifecycleObserver
implements HttpLifecycleObserver {
    private final FixedLevelLogger logger;

    LoggingHttpLifecycleObserver(String loggerName, LogLevel logLevel) {
        this.logger = Slf4jFixedLevelLoggers.newLogger(loggerName, logLevel);
    }

    @Override
    public HttpLifecycleObserver.HttpExchangeObserver onNewExchange() {
        return new LoggingHttpExchangeObserver(this.logger);
    }

    private static final class LoggingHttpExchangeObserver
    implements HttpLifecycleObserver.HttpExchangeObserver,
    HttpLifecycleObserver.HttpRequestObserver,
    HttpLifecycleObserver.HttpResponseObserver {
        private final long startTime = System.nanoTime();
        private final FixedLevelLogger logger;
        @Nullable
        private ConnectionInfo connInfo;
        @Nullable
        private HttpRequestMetaData requestMetaData;
        private long requestSize;
        private int requestTrailersCount;
        @Nullable
        private Object requestResult;
        @Nullable
        private HttpResponseMetaData responseMetaData;
        private long responseSize;
        private int responseTrailersCount;
        private long responseTimeMs;
        @Nullable
        private Object responseResult;

        private LoggingHttpExchangeObserver(FixedLevelLogger logger) {
            this.logger = logger;
        }

        @Override
        public void onConnectionSelected(ConnectionInfo info) {
            assert (this.connInfo == null);
            this.connInfo = info;
        }

        @Override
        public HttpLifecycleObserver.HttpRequestObserver onRequest(HttpRequestMetaData requestMetaData) {
            assert (this.requestMetaData == null);
            this.requestMetaData = requestMetaData;
            return this;
        }

        @Override
        public void onRequestData(Buffer data) {
            this.requestSize += (long)data.readableBytes();
        }

        @Override
        public void onRequestTrailers(HttpHeaders trailers) {
            this.requestTrailersCount = trailers.size();
        }

        @Override
        public void onRequestComplete() {
            assert (this.requestResult == null);
            assert (this.requestMetaData != null);
            this.requestResult = Result.complete;
        }

        @Override
        public void onRequestError(Throwable cause) {
            assert (this.requestResult == null);
            this.requestResult = cause;
        }

        @Override
        public void onRequestCancel() {
            assert (this.requestResult == null);
            this.requestResult = Result.cancelled;
        }

        @Override
        public HttpLifecycleObserver.HttpResponseObserver onResponse(HttpResponseMetaData responseMetaData) {
            assert (this.responseMetaData == null);
            this.responseMetaData = responseMetaData;
            return this;
        }

        @Override
        public void onResponseData(Buffer data) {
            this.responseSize += (long)data.readableBytes();
        }

        @Override
        public void onResponseTrailers(HttpHeaders trailers) {
            this.responseTrailersCount = trailers.size();
        }

        @Override
        public void onResponseComplete() {
            assert (this.responseResult == null);
            assert (this.responseMetaData != null);
            this.responseTimeMs = LoggingHttpExchangeObserver.durationMs(this.startTime);
            this.responseResult = Result.complete;
        }

        @Override
        public void onResponseError(Throwable cause) {
            assert (this.responseResult == null);
            this.responseTimeMs = LoggingHttpExchangeObserver.durationMs(this.startTime);
            this.responseResult = cause;
        }

        @Override
        public void onResponseCancel() {
            assert (this.responseResult == null);
            this.responseTimeMs = LoggingHttpExchangeObserver.durationMs(this.startTime);
            this.responseResult = Result.cancelled;
        }

        @Override
        public void onExchangeFinally() {
            HttpRequestMetaData requestMetaData = this.requestMetaData;
            assert (requestMetaData != null);
            HttpResponseMetaData responseMetaData = this.responseMetaData;
            Object requestResult = LoggingHttpExchangeObserver.unwrapResult(this.requestResult);
            if (requestResult == null) {
                requestResult = Result.cancelled;
            }
            assert (this.responseResult != null);
            if (responseMetaData != null) {
                this.logger.log("connection={} request=\"{} {} {}\" requestHeadersCount={} requestSize={} requestTrailersCount={} requestResult={} responseCode={} responseHeadersCount={} responseSize={} responseTrailersCount={} responseResult={} responseTime={}ms totalTime={}ms", this.connInfo == null ? "unknown" : this.connInfo, requestMetaData.method(), requestMetaData.requestTarget(), requestMetaData.version(), requestMetaData.headers().size(), this.requestSize, this.requestTrailersCount, requestResult, responseMetaData.status().code(), responseMetaData.headers().size(), this.responseSize, this.responseTrailersCount, LoggingHttpExchangeObserver.unwrapResult(this.responseResult), this.responseTimeMs, LoggingHttpExchangeObserver.durationMs(this.startTime), ThrowableUtils.combine(this.responseResult, requestResult));
            } else {
                this.logger.log("connection={} request=\"{} {} {}\" requestHeadersCount={} requestSize={} requestTrailersCount={} requestResult={} responseResult={} responseTime={}ms totalTime={}ms", this.connInfo == null ? "unknown" : this.connInfo, requestMetaData.method(), requestMetaData.requestTarget(), requestMetaData.version(), requestMetaData.headers().size(), this.requestSize, this.requestTrailersCount, requestResult, LoggingHttpExchangeObserver.unwrapResult(this.responseResult), this.responseTimeMs, LoggingHttpExchangeObserver.durationMs(this.startTime), ThrowableUtils.combine(this.responseResult, requestResult));
            }
        }

        @Nullable
        private static Object unwrapResult(@Nullable Object result) {
            return result instanceof Throwable ? Result.error : result;
        }

        private static long durationMs(long startTime) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        }

        private static enum Result {
            complete,
            error,
            cancelled;

        }
    }
}

