/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.ChannelHandlerContext;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.internal.QueueFullException;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.HttpObjectDecoder;
import io.servicetalk.http.netty.HttpObjectEncoder;
import io.servicetalk.http.netty.HttpResponseDecoder;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.DefaultNettyConnection;
import java.util.Objects;
import java.util.Queue;

final class HttpRequestEncoder
extends HttpObjectEncoder<HttpRequestMetaData> {
    private static final char SLASH = '/';
    private static final char QUESTION_MARK = '?';
    private static final int SLASH_AND_SPACE_SHORT = 12064;
    private static final int SPACE_SLASH_AND_SPACE_MEDIUM = 0x202F20;
    private final Queue<HttpRequestMethod> methodQueue;
    private final Queue<HttpResponseDecoder.Signal> signalsQueue;
    private boolean expectContinue;

    HttpRequestEncoder(Queue<HttpRequestMethod> methodQueue, Queue<HttpResponseDecoder.Signal> signalsQueue, int headersEncodedSizeAccumulator, int trailersEncodedSizeAccumulator, CloseHandler closeHandler) {
        super(headersEncodedSizeAccumulator, trailersEncodedSizeAccumulator, closeHandler);
        this.methodQueue = Objects.requireNonNull(methodQueue);
        this.signalsQueue = Objects.requireNonNull(signalsQueue);
    }

    @Override
    protected void sanitizeHeadersBeforeEncode(HttpRequestMetaData msg, boolean isAlwaysEmpty) {
        this.methodQueue.add(msg.method());
    }

    @Override
    protected HttpRequestMetaData castMetaData(Object msg) {
        return (HttpRequestMetaData)msg;
    }

    @Override
    protected void encodeInitialLine(ChannelHandlerContext ctx, Buffer stBuffer, HttpRequestMetaData message) {
        message.method().writeTo(stBuffer);
        String uri = message.requestTarget();
        if (uri.isEmpty()) {
            stBuffer.writeMedium(0x202F20);
        } else {
            CharSequence uriCharSequence = uri;
            boolean needSlash = false;
            int start = uri.indexOf("://");
            if (start != -1 && uri.charAt(0) != '/') {
                int index = uri.indexOf(63, start += 3);
                if (index == -1) {
                    if (uri.lastIndexOf(47) < start) {
                        needSlash = true;
                    }
                } else if (uri.lastIndexOf(47, index) < start) {
                    uriCharSequence = new StringBuilder(uri.length() + 1).append(uri).insert(index, '/');
                }
            }
            stBuffer.writeByte(32);
            stBuffer.writeUtf8(uriCharSequence);
            if (needSlash) {
                stBuffer.writeShort(12064);
            } else {
                stBuffer.writeByte(32);
            }
        }
        (message.version().major() == 1 ? message.version() : HttpProtocolVersion.HTTP_1_1).writeTo(stBuffer);
        stBuffer.writeShort(3338);
    }

    @Override
    protected long getContentLength(HttpRequestMetaData message) {
        long len = HttpObjectDecoder.getContentLength(message);
        return len < 0L && HeaderUtils.shouldAddZeroContentLength(message.method()) ? 0L : len;
    }

    @Override
    protected void onMetaData(ChannelHandlerContext ctx, HttpRequestMetaData metaData) {
        this.expectContinue = HeaderUtils.REQ_EXPECT_CONTINUE.test(metaData);
        if (!this.signalsQueue.offer(this.expectContinue ? HttpResponseDecoder.Signal.REQUEST_WITH_EXPECT_CONTINUE_SIGNAL : HttpResponseDecoder.Signal.REQUEST_SIGNAL)) {
            throw new QueueFullException("Can not enqueue a request type for the decoder");
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (this.expectContinue) {
            if (evt == DefaultNettyConnection.ContinueUserEvent.INSTANCE) {
                this.expectContinue = false;
            } else if (evt == DefaultNettyConnection.CancelWriteUserEvent.INSTANCE) {
                this.contentLenConsumed(ctx, null);
                this.expectContinue = false;
            }
        }
        ctx.fireUserEventTriggered(evt);
    }
}

