/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.ReferenceCountUtil;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.http.api.DefaultHttpExecutionContext;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.netty.KeepAliveManager;
import io.servicetalk.http.netty.NettyHttp2ExceptionUtils;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.FlushStrategyHolder;
import io.servicetalk.transport.netty.internal.NettyChannelListenableAsyncCloseable;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import io.servicetalk.transport.netty.internal.NettyIoExecutors;
import io.servicetalk.transport.netty.internal.NettyPipelineSslUtils;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.SocketOptionUtils;
import io.servicetalk.transport.netty.internal.StacklessClosedChannelException;
import java.net.SocketAddress;
import java.net.SocketOption;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;

class H2ParentConnectionContext
extends NettyChannelListenableAsyncCloseable
implements NettyConnectionContext,
HttpConnectionContext {
    final FlushStrategyHolder flushStrategyHolder;
    private final HttpExecutionContext executionContext;
    private final SingleSource.Processor<Throwable, Throwable> transportError = Processors.newSingleProcessor();
    private final CompletableSource.Processor onClosing = Processors.newCompletableProcessor();
    private final KeepAliveManager keepAliveManager;
    @Nullable
    final Long idleTimeoutMs;
    @Nullable
    private SSLSession sslSession;

    H2ParentConnectionContext(Channel channel, HttpExecutionContext executionContext, FlushStrategy flushStrategy, @Nullable Long idleTimeoutMs, KeepAliveManager keepAliveManager) {
        super(channel, executionContext.executor());
        this.executionContext = new DefaultHttpExecutionContext(executionContext.bufferAllocator(), (IoExecutor)NettyIoExecutors.fromNettyEventLoop(channel.eventLoop(), executionContext.ioExecutor().isIoThreadSupported()), executionContext.executor(), executionContext.executionStrategy());
        this.flushStrategyHolder = new FlushStrategyHolder(flushStrategy);
        this.idleTimeoutMs = idleTimeoutMs;
        this.keepAliveManager = keepAliveManager;
        this.onClose().subscribe(this.onClosing::onComplete);
    }

    @Override
    public final Cancellable updateFlushStrategy(NettyConnectionContext.FlushStrategyProvider strategyProvider) {
        return this.flushStrategyHolder.updateFlushStrategy(strategyProvider);
    }

    @Override
    public FlushStrategy defaultFlushStrategy() {
        return this.flushStrategyHolder.currentStrategy();
    }

    @Override
    public final Single<Throwable> transportError() {
        return SourceAdapters.fromSource(this.transportError);
    }

    @Override
    public final Completable onClosing() {
        return SourceAdapters.fromSource(this.onClosing);
    }

    @Override
    public final SocketAddress localAddress() {
        return this.channel().localAddress();
    }

    @Override
    public final SocketAddress remoteAddress() {
        return this.channel().remoteAddress();
    }

    @Override
    @Nullable
    public final SSLSession sslSession() {
        return this.sslSession;
    }

    @Override
    public final HttpExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    @Nullable
    public <T> T socketOption(SocketOption<T> option) {
        return SocketOptionUtils.getOption(option, this.channel().config(), this.idleTimeoutMs);
    }

    @Override
    public HttpProtocolVersion protocol() {
        return HttpProtocolVersion.HTTP_2_0;
    }

    @Override
    public final Channel nettyChannel() {
        return this.channel();
    }

    public final String toString() {
        return this.channel().toString();
    }

    @Override
    protected final void doCloseAsyncGracefully() {
        this.keepAliveManager.initiateGracefulClose(this.onClosing::onComplete);
    }

    final void trackActiveStream(Channel streamChannel) {
        this.keepAliveManager.trackActiveStream(streamChannel);
    }

    static abstract class AbstractH2ParentConnection
    extends ChannelInboundHandlerAdapter {
        final H2ParentConnectionContext parentContext;
        final boolean waitForSslHandshake;
        private final DelayedCancellable delayedCancellable;
        final ConnectionObserver observer;

        AbstractH2ParentConnection(H2ParentConnectionContext parentContext, DelayedCancellable delayedCancellable, boolean waitForSslHandshake, ConnectionObserver observer) {
            this.parentContext = parentContext;
            this.delayedCancellable = delayedCancellable;
            this.waitForSslHandshake = waitForSslHandshake;
            this.observer = observer;
        }

        abstract boolean hasSubscriber();

        abstract void tryCompleteSubscriber();

        abstract void tryFailSubscriber(Throwable var1);

        abstract boolean ackSettings(ChannelHandlerContext var1, Http2SettingsFrame var2);

        @Override
        public final void handlerAdded(ChannelHandlerContext ctx) {
            Channel channel = ctx.channel();
            this.delayedCancellable.delayedCancellable(channel::close);
            if (channel.isActive()) {
                this.doChannelActive(ctx);
            }
            if (!channel.config().isAutoRead()) {
                channel.config().setAutoRead(true);
            }
        }

        @Override
        public final void channelActive(ChannelHandlerContext ctx) {
            this.doChannelActive(ctx);
        }

        @Override
        public final void channelInactive(ChannelHandlerContext ctx) {
            this.doChannelClosed("channelInactive(...)");
        }

        @Override
        public final void handlerRemoved(ChannelHandlerContext ctx) {
            this.doChannelClosed("handlerRemoved(...)");
        }

        private void doChannelClosed(String method) {
            this.parentContext.onClosing.onComplete();
            if (this.hasSubscriber()) {
                this.tryFailSubscriber(StacklessClosedChannelException.newInstance(H2ParentConnectionContext.class, method));
            }
            this.parentContext.keepAliveManager.channelClosed();
        }

        @Override
        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            cause = NettyHttp2ExceptionUtils.wrapIfNecessary(cause);
            if (this.observer != NoopTransportObserver.NoopConnectionObserver.INSTANCE) {
                ChannelCloseUtils.assignConnectionError(ctx.channel(), cause);
            }
            this.parentContext.transportError.onSuccess(cause);
        }

        @Override
        public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            try {
                if (evt instanceof SslHandshakeCompletionEvent) {
                    this.parentContext.sslSession = NettyPipelineSslUtils.extractSslSessionAndReport(ctx.pipeline(), (SslHandshakeCompletionEvent)evt, this::tryFailSubscriber, this.observer != NoopTransportObserver.NoopConnectionObserver.INSTANCE);
                    this.tryCompleteSubscriber();
                } else if (evt == ChannelInputShutdownReadComplete.INSTANCE || evt == SslCloseCompletionEvent.SUCCESS) {
                    this.parentContext.keepAliveManager.channelInputShutdown();
                } else if (evt == ChannelOutputShutdownEvent.INSTANCE) {
                    this.parentContext.keepAliveManager.channelOutputShutdown();
                }
            }
            finally {
                ReferenceCountUtil.release(evt);
            }
        }

        @Override
        public final void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof Http2SettingsFrame) {
                if (this.ackSettings(ctx, (Http2SettingsFrame)msg)) {
                    ctx.writeAndFlush(Http2SettingsAckFrame.INSTANCE);
                }
            } else if (msg instanceof Http2GoAwayFrame) {
                Http2GoAwayFrame goAwayFrame = (Http2GoAwayFrame)msg;
                goAwayFrame.release();
                this.parentContext.keepAliveManager.initiateGracefulClose(this.parentContext.onClosing::onComplete);
            } else if (msg instanceof Http2PingFrame) {
                this.parentContext.keepAliveManager.pingReceived((Http2PingFrame)msg);
            } else if (!(msg instanceof Http2SettingsAckFrame)) {
                ctx.fireChannelRead(msg);
            }
        }

        private void doChannelActive(ChannelHandlerContext ctx) {
            if (this.waitForSslHandshake) {
                ctx.read();
            } else {
                this.tryCompleteSubscriber();
            }
        }
    }
}

