/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.H2ServerParentChannelInitializer;
import io.servicetalk.http.netty.OptimizedHttp2FrameCodecBuilder;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import java.util.function.BiPredicate;

final class H2ClientParentChannelInitializer
implements ChannelInitializer {
    private final H2ProtocolConfig config;

    H2ClientParentChannelInitializer(H2ProtocolConfig config) {
        this.config = config;
    }

    @Override
    public void init(Channel channel) {
        Http2FrameCodecBuilder multiplexCodecBuilder = new OptimizedHttp2FrameCodecBuilder(false).decoupleCloseAndGoAway(true).autoAckSettingsFrame(false).autoAckPingFrame(false).gracefulShutdownTimeoutMillis(-1L);
        multiplexCodecBuilder.initialSettings().pushEnabled(false).maxConcurrentStreams(0L);
        BiPredicate<CharSequence, CharSequence> headersSensitivityDetector = this.config.headersSensitivityDetector();
        multiplexCodecBuilder.headerSensitivityDetector(headersSensitivityDetector::test);
        H2ServerParentChannelInitializer.initFrameLogger(multiplexCodecBuilder, this.config.frameLoggerConfig());
        channel.pipeline().addLast(multiplexCodecBuilder.build(), new Http2MultiplexHandler(H2PushStreamHandler.INSTANCE));
    }

    @ChannelHandler.Sharable
    private static final class H2PushStreamHandler
    extends ChannelInboundHandlerAdapter {
        static final ChannelInboundHandlerAdapter INSTANCE = new H2PushStreamHandler();

        private H2PushStreamHandler() {
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx) {
            ctx.writeAndFlush(new DefaultHttp2GoAwayFrame(Http2Error.PROTOCOL_ERROR));
        }
    }
}

