/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalarValueSubscription<T>
implements PublisherSource.Subscription {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScalarValueSubscription.class);
    @Nullable
    private final T value;
    private final PublisherSource.Subscriber<? super T> subscriber;
    private boolean deliveredData;

    public ScalarValueSubscription(@Nullable T value, PublisherSource.Subscriber<? super T> subscriber) {
        this.value = value;
        this.subscriber = Objects.requireNonNull(subscriber);
    }

    @Override
    public void request(long n) {
        if (!this.deliveredData) {
            this.deliveredData = true;
            if (SubscriberUtils.isRequestNValid(n)) {
                try {
                    this.subscriber.onNext(this.value);
                }
                catch (Throwable cause) {
                    try {
                        this.subscriber.onError(cause);
                    }
                    catch (Throwable t) {
                        LOGGER.info("Ignoring exception from onError of Subscriber {}.", (Object)this.subscriber, (Object)t);
                    }
                    return;
                }
                try {
                    this.subscriber.onComplete();
                }
                catch (Throwable t) {
                    LOGGER.info("Ignoring exception from onComplete of Subscriber {}.", (Object)this.subscriber, (Object)t);
                }
            } else {
                try {
                    this.subscriber.onError(SubscriberUtils.newExceptionForInvalidRequestN(n));
                }
                catch (Throwable t) {
                    LOGGER.info("Ignoring exception from onError of Subscriber {}.", (Object)this.subscriber, (Object)t);
                }
            }
        }
    }

    @Override
    public void cancel() {
        this.deliveredData = true;
    }
}

