/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.AutoClosableUtils;
import io.servicetalk.concurrent.internal.ConcurrentUtils;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;

final class PublisherConcatMapIterable<T, U>
extends AbstractSynchronousPublisherOperator<T, U> {
    private static final long CANCEL_PENDING = -1L;
    private static final long CANCELLED = Long.MIN_VALUE;
    private final Function<? super T, ? extends Iterable<? extends U>> mapper;

    PublisherConcatMapIterable(Publisher<T> original, Function<? super T, ? extends Iterable<? extends U>> mapper) {
        super(original);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super U> subscriber) {
        return new FlatMapIterableSubscriber<T, U>(this.mapper, subscriber);
    }

    private static final class FlatMapIterableSubscriber<T, U>
    implements PublisherSource.Subscriber<T>,
    PublisherSource.Subscription {
        private static final AtomicLongFieldUpdater<FlatMapIterableSubscriber> requestNUpdater = AtomicLongFieldUpdater.newUpdater(FlatMapIterableSubscriber.class, "requestN");
        private static final AtomicIntegerFieldUpdater<FlatMapIterableSubscriber> emittingUpdater = AtomicIntegerFieldUpdater.newUpdater(FlatMapIterableSubscriber.class, "emitting");
        private final Function<? super T, ? extends Iterable<? extends U>> mapper;
        private final PublisherSource.Subscriber<? super U> target;
        @Nullable
        private PublisherSource.Subscription sourceSubscription;
        @Nullable
        private TerminalNotification terminalNotification;
        private Iterator<? extends U> currentIterator = Collections.emptyIterator();
        private volatile long requestN;
        private volatile int emitting;

        FlatMapIterableSubscriber(Function<? super T, ? extends Iterable<? extends U>> mapper, PublisherSource.Subscriber<? super U> target) {
            this.target = target;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            if (SubscriberUtils.checkDuplicateSubscription(this.sourceSubscription, s)) {
                this.sourceSubscription = s;
                this.target.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T u) {
            this.currentIterator = Objects.requireNonNull(this.mapper.apply(u).iterator());
            this.tryDrainIterator(ErrorHandlingStrategyInDrain.Throw);
        }

        @Override
        public void onError(Throwable t) {
            this.terminalNotification = TerminalNotification.error(t);
            this.tryDrainIterator(ErrorHandlingStrategyInDrain.Propagate);
        }

        @Override
        public void onComplete() {
            this.terminalNotification = TerminalNotification.complete();
            this.tryDrainIterator(ErrorHandlingStrategyInDrain.Propagate);
        }

        @Override
        public void request(long n) {
            assert (this.sourceSubscription != null);
            if (!SubscriberUtils.isRequestNValid(n)) {
                this.sourceSubscription.request(n);
            } else {
                requestNUpdater.accumulateAndGet(this, n, FlowControlUtils::addWithOverflowProtectionIfNotNegative);
                this.tryDrainIterator(ErrorHandlingStrategyInDrain.PropagateAndCancel);
            }
        }

        @Override
        public void cancel() {
            long currRequestN;
            while ((currRequestN = this.requestN) >= 0L) {
                if (!requestNUpdater.compareAndSet(this, currRequestN, -1L)) continue;
                if (!ConcurrentUtils.tryAcquireLock(emittingUpdater, this)) break;
                try {
                    this.requestN = Long.MIN_VALUE;
                    this.doCancel();
                    break;
                }
                finally {
                    if (!ConcurrentUtils.releaseLock(emittingUpdater, this)) {
                        this.tryDrainIterator(ErrorHandlingStrategyInDrain.Propagate);
                    }
                }
            }
        }

        private void doCancel() {
            assert (this.sourceSubscription != null);
            Iterator<? extends U> currentIterator = this.currentIterator;
            this.currentIterator = EmptyIterator.instance();
            try {
                FlatMapIterableSubscriber.tryClose(currentIterator);
            }
            finally {
                this.sourceSubscription.cancel();
            }
        }

        private static <U> void tryClose(Iterator<? extends U> currentIterator) {
            if (currentIterator instanceof AutoCloseable) {
                AutoClosableUtils.closeAndReThrowUnchecked((AutoCloseable)((Object)currentIterator));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void tryDrainIterator(ErrorHandlingStrategyInDrain errorHandlingStrategyInDrain) {
            boolean hasNext = false;
            boolean thrown = false;
            boolean terminated = false;
            boolean releasedLock = false;
            while (ConcurrentUtils.tryAcquireLock(emittingUpdater, this)) {
                block36: {
                    long currRequestN;
                    long initialRequestN = currRequestN = this.requestN;
                    try {
                        try {
                            while ((hasNext = this.currentIterator.hasNext()) && currRequestN > 0L) {
                                --currRequestN;
                                this.target.onNext(this.currentIterator.next());
                            }
                        }
                        catch (Throwable cause) {
                            switch (errorHandlingStrategyInDrain) {
                                case PropagateAndCancel: {
                                    terminated = true;
                                    SubscriberUtils.safeOnError(this.target, cause);
                                    this.doCancel();
                                    if (terminated) return;
                                    currRequestN = requestNUpdater.accumulateAndGet(this, currRequestN - initialRequestN, FlowControlUtils::addWithOverflowProtectionIfNotNegative);
                                    try {
                                        if (currRequestN == -1L) {
                                            terminated = true;
                                            this.requestN = Long.MIN_VALUE;
                                            if (thrown) return;
                                            this.doCancel();
                                            return;
                                        } else {
                                            if (this.terminalNotification != null || hasNext || currRequestN <= 0L || this.currentIterator == EmptyIterator.instance() && !thrown) return;
                                            this.currentIterator = EmptyIterator.instance();
                                            if (this.sourceSubscription == null) return;
                                            this.sourceSubscription.request(1L);
                                        }
                                        return;
                                    }
                                    finally {
                                        releasedLock = ConcurrentUtils.releaseLock(emittingUpdater, this);
                                    }
                                }
                                case Propagate: {
                                    terminated = true;
                                    SubscriberUtils.safeOnError(this.target, cause);
                                    FlatMapIterableSubscriber.tryClose(this.currentIterator);
                                    if (terminated) return;
                                    currRequestN = requestNUpdater.accumulateAndGet(this, currRequestN - initialRequestN, FlowControlUtils::addWithOverflowProtectionIfNotNegative);
                                    try {
                                        if (currRequestN == -1L) {
                                            terminated = true;
                                            this.requestN = Long.MIN_VALUE;
                                            if (thrown) return;
                                            this.doCancel();
                                            return;
                                        } else {
                                            if (this.terminalNotification != null || hasNext || currRequestN <= 0L || this.currentIterator == EmptyIterator.instance() && !thrown) return;
                                            this.currentIterator = EmptyIterator.instance();
                                            if (this.sourceSubscription == null) return;
                                            this.sourceSubscription.request(1L);
                                        }
                                        return;
                                    }
                                    finally {
                                        releasedLock = ConcurrentUtils.releaseLock(emittingUpdater, this);
                                    }
                                }
                                case Throw: {
                                    hasNext = false;
                                    thrown = true;
                                    Iterator<? extends U> currentIterator = this.currentIterator;
                                    this.currentIterator = EmptyIterator.instance();
                                    FlatMapIterableSubscriber.tryClose(currentIterator);
                                    throw cause;
                                }
                            }
                            throw new IllegalArgumentException("Unknown error handling strategy: " + (Object)((Object)errorHandlingStrategyInDrain));
                        }
                        if (this.terminalNotification != null && !hasNext) {
                            terminated = true;
                            this.terminalNotification.terminate(this.target);
                        }
                        break block36;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (!terminated) {
                            currRequestN = requestNUpdater.accumulateAndGet(this, currRequestN - initialRequestN, FlowControlUtils::addWithOverflowProtectionIfNotNegative);
                            try {
                                if (currRequestN == -1L) {
                                    terminated = true;
                                    this.requestN = Long.MIN_VALUE;
                                    if (!thrown) {
                                        this.doCancel();
                                    }
                                } else if (this.terminalNotification == null && !hasNext && currRequestN > 0L && (this.currentIterator != EmptyIterator.instance() || thrown)) {
                                    this.currentIterator = EmptyIterator.instance();
                                    if (this.sourceSubscription != null) {
                                        this.sourceSubscription.request(1L);
                                    }
                                }
                            }
                            finally {
                                releasedLock = ConcurrentUtils.releaseLock(emittingUpdater, this);
                            }
                        }
                    }
                }
                if (!terminated && !releasedLock) continue;
            }
        }

        private static final class EmptyIterator<U>
        implements Iterator<U> {
            private static final EmptyIterator INSTANCE = new EmptyIterator();

            private EmptyIterator() {
            }

            static <T> EmptyIterator<T> instance() {
                return INSTANCE;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public U next() {
                throw new NoSuchElementException();
            }
        }

        private static enum ErrorHandlingStrategyInDrain {
            PropagateAndCancel,
            Propagate,
            Throw;

        }
    }
}

