/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.PublisherToSingleOperator;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;

final class LiftSynchronousPublisherToSingle<T, R>
extends Single<R>
implements SingleSource<R> {
    private final Publisher<T> original;
    private final PublisherToSingleOperator<? super T, ? extends R> customOperator;

    LiftSynchronousPublisherToSingle(Publisher<T> original, PublisherToSingleOperator<? super T, ? extends R> customOperator) {
        this.original = original;
        this.customOperator = Objects.requireNonNull(customOperator);
    }

    @Override
    protected void handleSubscribe(SingleSource.Subscriber<? super R> subscriber) {
        SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)new UnsupportedOperationException("Subscribe with no executor is not supported for " + this.getClass()));
    }

    @Override
    public void subscribe(SingleSource.Subscriber<? super R> subscriber) {
        this.subscribeInternal(subscriber);
    }

    @Override
    void handleSubscribe(SingleSource.Subscriber<? super R> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(this.customOperator.apply(subscriber), contextMap, contextProvider);
    }
}

