/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ForEachSubscriber<T>
extends DelayedCancellable
implements PublisherSource.Subscriber<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForEachSubscriber.class);
    private final Consumer<? super T> forEach;

    ForEachSubscriber(Consumer<? super T> forEach) {
        this.forEach = Objects.requireNonNull(forEach);
    }

    @Override
    public void onSubscribe(PublisherSource.Subscription s) {
        s.request(Long.MAX_VALUE);
        this.delayedCancellable(s);
    }

    @Override
    public void onNext(T t) {
        this.forEach.accept(t);
    }

    @Override
    public void onError(Throwable t) {
        LOGGER.debug("Received exception from the source.", t);
    }

    @Override
    public void onComplete() {
    }
}

