/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.concurrent.api.DefaultAsyncContextProvider;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.Objects;

final class ContextPreservingRunnable
implements Runnable {
    private final ContextMap saved;
    private final Runnable delegate;

    ContextPreservingRunnable(Runnable delegate) {
        this(delegate, DefaultAsyncContextProvider.INSTANCE.context());
    }

    ContextPreservingRunnable(Runnable delegate, ContextMap current) {
        this.saved = Objects.requireNonNull(current);
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)((Object)currentThread);
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.delegate.run();
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.slowPath();
        }
    }

    private void slowPath() {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.delegate.run();
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }
}

