/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.OnSubscribeIgnoringSubscriberForOffloading;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class CompletableToPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Completable original;

    CompletableToPublisher(Completable original) {
        this.original = original;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ConversionSubscriber(subscriber, contextMap, contextProvider), contextMap, contextProvider);
    }

    private static final class ConversionSubscriber<T>
    extends SequentialCancellable
    implements CompletableSource.Subscriber,
    PublisherSource.Subscription {
        private static final AtomicIntegerFieldUpdater<ConversionSubscriber> terminatedUpdater = AtomicIntegerFieldUpdater.newUpdater(ConversionSubscriber.class, "terminated");
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final ContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        private volatile int terminated;

        private ConversionSubscriber(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
            this.subscriber = subscriber;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.nextCancellable(cancellable);
            this.subscriber.onSubscribe(this);
        }

        @Override
        public void onComplete() {
            if (terminatedUpdater.compareAndSet(this, 0, 1)) {
                this.subscriber.onComplete();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (terminatedUpdater.compareAndSet(this, 0, 1)) {
                this.subscriber.onError(t);
            }
        }

        @Override
        public void request(long n) {
            if (!SubscriberUtils.isRequestNValid(n) && terminatedUpdater.compareAndSet(this, 0, 1)) {
                PublisherSource.Subscriber<T> wrapped = OnSubscribeIgnoringSubscriberForOffloading.wrapWithDummyOnSubscribe(this.subscriber, this.contextMap, this.contextProvider);
                try {
                    this.cancel();
                }
                catch (Throwable t) {
                    wrapped.onError(t);
                    return;
                }
                wrapped.onError(SubscriberUtils.newExceptionForInvalidRequestN(n));
            }
        }
    }
}

