/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingleOperator;
import io.servicetalk.concurrent.api.ComposedCancellable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SingleTerminalSignalConsumer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class BeforeFinallySingle<T>
extends AbstractSynchronousSingleOperator<T, T> {
    private final SingleTerminalSignalConsumer<? super T> doFinally;

    BeforeFinallySingle(Single<T> original, SingleTerminalSignalConsumer<? super T> doFinally) {
        super(original);
        this.doFinally = Objects.requireNonNull(doFinally);
    }

    @Override
    public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
        return new BeforeFinallySingleSubscriber<T>(subscriber, this.doFinally);
    }

    private static final class BeforeFinallySingleSubscriber<T>
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super T> original;
        private final SingleTerminalSignalConsumer<? super T> doFinally;
        private static final AtomicIntegerFieldUpdater<BeforeFinallySingleSubscriber> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(BeforeFinallySingleSubscriber.class, "done");
        private volatile int done;

        BeforeFinallySingleSubscriber(SingleSource.Subscriber<? super T> original, SingleTerminalSignalConsumer<? super T> doFinally) {
            this.original = original;
            this.doFinally = doFinally;
        }

        @Override
        public void onSubscribe(Cancellable originalCancellabe) {
            this.original.onSubscribe(new ComposedCancellable(() -> {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.cancel();
                }
            }, originalCancellabe));
        }

        @Override
        public void onSuccess(T value) {
            try {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onSuccess(value);
                }
            }
            catch (Throwable error) {
                this.original.onError(error);
                return;
            }
            this.original.onSuccess(value);
        }

        @Override
        public void onError(Throwable cause) {
            try {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onError(cause);
                }
            }
            catch (Throwable err) {
                err.addSuppressed(cause);
                this.original.onError(err);
                return;
            }
            this.original.onError(cause);
        }
    }
}

