/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api.internal;

import io.servicetalk.client.api.ConsumableEvent;
import io.servicetalk.client.api.internal.AbstractReservableRequestConcurrencyController;
import io.servicetalk.client.api.internal.RequestConcurrencyController;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;

final class ReservableRequestConcurrencyControllerMulti
extends AbstractReservableRequestConcurrencyController {
    private final int maxRequests;

    ReservableRequestConcurrencyControllerMulti(Publisher<? extends ConsumableEvent<Integer>> maxConcurrency, Completable onClosing, int maxRequests) {
        super(maxConcurrency, onClosing);
        this.maxRequests = maxRequests;
    }

    @Override
    public RequestConcurrencyController.Result tryRequest() {
        int currentPending;
        int maxConcurrency = this.lastSeenMaxValue(this.maxRequests);
        do {
            if ((currentPending = this.pendingRequests()) < 0) {
                return RequestConcurrencyController.Result.RejectedPermanently;
            }
            if (currentPending < maxConcurrency) continue;
            return RequestConcurrencyController.Result.RejectedTemporary;
        } while (!this.casPendingRequests(currentPending, currentPending + 1));
        return RequestConcurrencyController.Result.Accepted;
    }
}

