/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.Channel;
import io.servicetalk.logging.api.UserDataLoggerConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.ConnectionObserverInitializer;
import io.servicetalk.transport.netty.internal.IdleTimeoutInitializer;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.SniServerChannelInitializer;
import io.servicetalk.transport.netty.internal.SslServerChannelInitializer;
import io.servicetalk.transport.netty.internal.WireLoggingInitializer;
import javax.annotation.Nullable;

public class TcpServerChannelInitializer
implements ChannelInitializer {
    private final ChannelInitializer delegate;

    public TcpServerChannelInitializer(ReadOnlyTcpServerConfig config, ConnectionObserver observer) {
        ChannelInitializer delegate = ChannelInitializer.defaultInitializer();
        if (observer != NoopTransportObserver.NoopConnectionObserver.INSTANCE) {
            delegate = delegate.andThen(new ConnectionObserverInitializer(observer, config.sslContext() != null, false));
        }
        if (config.idleTimeoutMs() != null) {
            delegate = delegate.andThen(new IdleTimeoutInitializer(config.idleTimeoutMs()));
        }
        if (config.sniMapping() != null) {
            delegate = delegate.andThen(new SniServerChannelInitializer(config.sniMapping()));
        } else if (config.sslContext() != null) {
            delegate = delegate.andThen(new SslServerChannelInitializer(config.sslContext()));
        }
        this.delegate = TcpServerChannelInitializer.initWireLogger(delegate, config.wireLoggerConfig());
    }

    @Override
    public void init(Channel channel) {
        this.delegate.init(channel);
    }

    static ChannelInitializer initWireLogger(ChannelInitializer delegate, @Nullable UserDataLoggerConfig wireLoggerConfig) {
        if (wireLoggerConfig == null) {
            return delegate;
        }
        return delegate.andThen(new WireLoggingInitializer(wireLoggerConfig.loggerName(), wireLoggerConfig.logLevel(), wireLoggerConfig.logUserData()));
    }
}

