/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SniCompletionEvent;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.http.netty.ChannelInitSingle;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.StacklessClosedChannelException;
import javax.annotation.Nullable;

final class SniCompleteChannelSingle
extends ChannelInitSingle<SniCompletionEvent> {
    SniCompleteChannelSingle(Channel channel, ChannelInitializer channelInitializer) {
        super(channel, channelInitializer);
    }

    @Override
    protected ChannelHandler newChannelHandler(SingleSource.Subscriber<? super SniCompletionEvent> subscriber) {
        return new SniCompleteChannelHandler(subscriber);
    }

    private static final class SniCompleteChannelHandler
    extends ChannelInboundHandlerAdapter {
        @Nullable
        private SingleSource.Subscriber<? super SniCompletionEvent> subscriber;

        SniCompleteChannelHandler(SingleSource.Subscriber<? super SniCompletionEvent> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            ctx.read();
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof SniCompletionEvent && this.subscriber != null) {
                ctx.pipeline().remove(this);
                SingleSource.Subscriber<? super SniCompletionEvent> subscriberCopy = this.subscriber;
                this.subscriber = null;
                subscriberCopy.onSuccess((SniCompletionEvent)evt);
            }
            ctx.fireUserEventTriggered(evt);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (this.subscriber != null) {
                this.propagateError(ctx.channel(), StacklessClosedChannelException.newInstance(SniCompleteChannelHandler.class, "exceptionCaught(...)").initCause(cause));
            } else {
                ctx.fireExceptionCaught(cause);
                ctx.close();
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            if (this.subscriber != null) {
                this.propagateError(ctx.channel(), StacklessClosedChannelException.newInstance(SniCompleteChannelHandler.class, "channelInactive(...)"));
            } else {
                ctx.fireChannelInactive();
            }
        }

        private void propagateError(Channel channel, Throwable cause) {
            assert (this.subscriber != null);
            ChannelCloseUtils.assignConnectionError(channel, cause);
            SingleSource.Subscriber<? super SniCompletionEvent> subscriberCopy = this.subscriber;
            this.subscriber = null;
            subscriberCopy.onError(cause);
        }
    }
}

