/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.ContextAwareExecutorUtils;
import io.servicetalk.concurrent.api.ContextPreservingCallable;
import io.servicetalk.concurrent.api.ContextPreservingRunnable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ContextPreservingExecutorService<X extends ExecutorService>
implements ExecutorService {
    protected final X delegate;

    ContextPreservingExecutorService(X delegate) {
        this.delegate = (ExecutorService)Objects.requireNonNull(delegate);
    }

    @Override
    public final void execute(Runnable command) {
        this.delegate.execute(new ContextPreservingRunnable(command));
    }

    @Override
    public final void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public final List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public final boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public final <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(new ContextPreservingCallable<T>(task));
    }

    @Override
    public final <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(new ContextPreservingRunnable(task), result);
    }

    @Override
    public final Future<?> submit(Runnable task) {
        return this.delegate.submit(new ContextPreservingRunnable(task));
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(ContextAwareExecutorUtils.wrap(tasks));
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(ContextAwareExecutorUtils.wrap(tasks), timeout, unit);
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.delegate.invokeAny(ContextAwareExecutorUtils.wrap(tasks));
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.invokeAny(ContextAwareExecutorUtils.wrap(tasks), timeout, unit);
    }

    static ExecutorService of(ExecutorService executor) {
        return executor instanceof ContextPreservingExecutorService ? executor : new ContextPreservingExecutorService<ExecutorService>(executor);
    }
}

