/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.Limits;
import io.netty.incubator.channel.uring.AbstractIOUringChannel;
import io.netty.incubator.channel.uring.IOUringRecvByteAllocatorHandle;
import io.netty.incubator.channel.uring.IOUringSubmissionQueue;
import io.netty.incubator.channel.uring.LinuxSocket;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Executor;

abstract class AbstractIOUringStreamChannel
extends AbstractIOUringChannel
implements DuplexChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractIOUringStreamChannel.class);

    AbstractIOUringStreamChannel(Channel parent, LinuxSocket socket) {
        super(parent, socket);
    }

    protected AbstractIOUringStreamChannel(Channel parent, LinuxSocket socket, boolean active) {
        super(parent, socket, active);
    }

    AbstractIOUringStreamChannel(Channel parent, LinuxSocket fd, SocketAddress remote) {
        super(parent, fd, remote);
    }

    @Override
    protected AbstractIOUringChannel.AbstractUringUnsafe newUnsafe() {
        return new IOUringStreamUnsafe();
    }

    @Override
    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    @Override
    public ChannelFuture shutdown(final ChannelPromise promise) {
        ChannelFuture shutdownOutputFuture = this.shutdownOutput();
        if (shutdownOutputFuture.isDone()) {
            this.shutdownOutputDone(shutdownOutputFuture, promise);
        } else {
            shutdownOutputFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture shutdownOutputFuture) throws Exception {
                    AbstractIOUringStreamChannel.this.shutdownOutputDone(shutdownOutputFuture, promise);
                }
            });
        }
        return promise;
    }

    @Override
    protected final void doShutdownOutput() throws Exception {
        this.socket.shutdown(false, true);
    }

    private void shutdownInput0(ChannelPromise promise) {
        try {
            this.socket.shutdown(true, false);
            promise.setSuccess();
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.socket.isShutdown();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(final ChannelPromise promise) {
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)this.unsafe()).shutdownOutput(promise);
        } else {
            loop.execute(new Runnable(){

                @Override
                public void run() {
                    ((AbstractChannel.AbstractUnsafe)AbstractIOUringStreamChannel.this.unsafe()).shutdownOutput(promise);
                }
            });
        }
        return promise;
    }

    @Override
    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownInput(final ChannelPromise promise) {
        Executor closeExecutor = ((IOUringStreamUnsafe)this.unsafe()).prepareToClose();
        if (closeExecutor != null) {
            closeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractIOUringStreamChannel.this.shutdownInput0(promise);
                }
            });
        } else {
            EventLoop loop = this.eventLoop();
            if (loop.inEventLoop()) {
                this.shutdownInput0(promise);
            } else {
                loop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractIOUringStreamChannel.this.shutdownInput0(promise);
                    }
                });
            }
        }
        return promise;
    }

    private void shutdownOutputDone(final ChannelFuture shutdownOutputFuture, final ChannelPromise promise) {
        ChannelFuture shutdownInputFuture = this.shutdownInput();
        if (shutdownInputFuture.isDone()) {
            AbstractIOUringStreamChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
        } else {
            shutdownInputFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture shutdownInputFuture) throws Exception {
                    AbstractIOUringStreamChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
                }
            });
        }
    }

    private static void shutdownDone(ChannelFuture shutdownOutputFuture, ChannelFuture shutdownInputFuture, ChannelPromise promise) {
        Throwable shutdownOutputCause = shutdownOutputFuture.cause();
        Throwable shutdownInputCause = shutdownInputFuture.cause();
        if (shutdownOutputCause != null) {
            if (shutdownInputCause != null) {
                logger.info("Exception suppressed because a previous exception occurred.", shutdownInputCause);
            }
            promise.setFailure(shutdownOutputCause);
        } else if (shutdownInputCause != null) {
            promise.setFailure(shutdownInputCause);
        } else {
            promise.setSuccess();
        }
    }

    @Override
    protected void doRegister() throws Exception {
        super.doRegister();
        if (this.active) {
            this.schedulePollRdHup();
        }
    }

    private final class IOUringStreamUnsafe
    extends AbstractIOUringChannel.AbstractUringUnsafe {
        private ByteBuf readBuffer;
        private IovArray iovArray;

        private IOUringStreamUnsafe() {
            super(AbstractIOUringStreamChannel.this);
        }

        @Override
        protected Executor prepareToClose() {
            return super.prepareToClose();
        }

        @Override
        protected int scheduleWriteMultiple(ChannelOutboundBuffer in) {
            assert (this.iovArray == null);
            int numElements = Math.min(in.size(), Limits.IOV_MAX);
            ByteBuf iovArrayBuffer = AbstractIOUringStreamChannel.this.alloc().directBuffer(numElements * IovArray.IOV_SIZE);
            this.iovArray = new IovArray(iovArrayBuffer);
            try {
                int offset = this.iovArray.count();
                in.forEachFlushedMessage(this.iovArray);
                AbstractIOUringStreamChannel.this.submissionQueue().addWritev(AbstractIOUringStreamChannel.this.socket.intValue(), this.iovArray.memoryAddress(offset), this.iovArray.count() - offset, (short)0);
            }
            catch (Exception e) {
                this.iovArray.release();
                this.iovArray = null;
                this.scheduleWriteSingle(in.current());
            }
            return 1;
        }

        @Override
        protected int scheduleWriteSingle(Object msg) {
            assert (this.iovArray == null);
            ByteBuf buf = (ByteBuf)msg;
            IOUringSubmissionQueue submissionQueue = AbstractIOUringStreamChannel.this.submissionQueue();
            submissionQueue.addWrite(AbstractIOUringStreamChannel.this.socket.intValue(), buf.memoryAddress(), buf.readerIndex(), buf.writerIndex(), (short)0);
            return 1;
        }

        @Override
        protected int scheduleRead0() {
            assert (this.readBuffer == null);
            IOUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ByteBuf byteBuf = allocHandle.allocate(AbstractIOUringStreamChannel.this.alloc());
            IOUringSubmissionQueue submissionQueue = AbstractIOUringStreamChannel.this.submissionQueue();
            allocHandle.attemptedBytesRead(byteBuf.writableBytes());
            this.readBuffer = byteBuf;
            submissionQueue.addRead(AbstractIOUringStreamChannel.this.socket.intValue(), byteBuf.memoryAddress(), byteBuf.writerIndex(), byteBuf.capacity(), (short)0);
            return 1;
        }

        @Override
        protected void readComplete0(int res, int data, int outstanding) {
            boolean close = false;
            IOUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ChannelPipeline pipeline = AbstractIOUringStreamChannel.this.pipeline();
            ByteBuf byteBuf = this.readBuffer;
            this.readBuffer = null;
            assert (byteBuf != null);
            try {
                if (res < 0) {
                    allocHandle.lastBytesRead(Errors.ioResult("io_uring read", res));
                } else if (res > 0) {
                    byteBuf.writerIndex(byteBuf.writerIndex() + res);
                    allocHandle.lastBytesRead(res);
                } else {
                    allocHandle.lastBytesRead(-1);
                }
                if (allocHandle.lastBytesRead() <= 0) {
                    byteBuf.release();
                    byteBuf = null;
                    boolean bl = close = allocHandle.lastBytesRead() < 0;
                    if (close) {
                        this.shutdownInput(false);
                    }
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                    return;
                }
                allocHandle.incMessagesRead(1);
                pipeline.fireChannelRead(byteBuf);
                byteBuf = null;
                if (allocHandle.continueReading()) {
                    this.scheduleRead();
                } else {
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                }
            }
            catch (Throwable t) {
                this.handleReadException(pipeline, byteBuf, t, close, allocHandle);
            }
        }

        private void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean close, IOUringRecvByteAllocatorHandle allocHandle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    pipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            allocHandle.readComplete();
            pipeline.fireChannelReadComplete();
            pipeline.fireExceptionCaught(cause);
            if (close || cause instanceof IOException) {
                this.shutdownInput(false);
            }
        }

        @Override
        boolean writeComplete0(int res, int data, int outstanding) {
            IovArray iovArray = this.iovArray;
            if (iovArray != null) {
                this.iovArray = null;
                iovArray.release();
            }
            if (res >= 0) {
                AbstractIOUringStreamChannel.this.unsafe().outboundBuffer().removeBytes(res);
            } else {
                try {
                    if (Errors.ioResult("io_uring write", res) == 0) {
                        return false;
                    }
                }
                catch (Throwable cause) {
                    this.handleWriteError(cause);
                }
            }
            return true;
        }
    }
}

