/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.servicetalk.transport.api.SecurityConfigurator;
import io.servicetalk.transport.api.ServerSecurityConfigurator;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.ServerSslConfigBuilder;
import io.servicetalk.transport.api.SslClientAuthMode;
import io.servicetalk.transport.api.SslProvider;
import io.servicetalk.transport.netty.internal.ClientSecurityConfig;
import io.servicetalk.transport.netty.internal.ReadOnlyServerSecurityConfig;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

@Deprecated
public class ServerSecurityConfig
extends ReadOnlyServerSecurityConfig {
    public void trustManager(Supplier<InputStream> trustCertChainSupplier) {
        this.trustCertChainSupplier = Objects.requireNonNull(trustCertChainSupplier);
    }

    public void trustManager(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = Objects.requireNonNull(trustManagerFactory);
    }

    public void protocols(String ... protocols) {
        this.protocols = Arrays.asList(protocols);
    }

    public void ciphers(Iterable<String> ciphers) {
        this.ciphers = ClientSecurityConfig.toList(ciphers);
    }

    public void sessionCacheSize(long sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
    }

    public void sessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void provider(SecurityConfigurator.SslProvider provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    public void keyManager(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = Objects.requireNonNull(keyManagerFactory);
    }

    public void keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier) {
        this.keyCertChainSupplier = Objects.requireNonNull(keyCertChainSupplier);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.keyPassword = null;
    }

    public void keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier, String keyPassword) {
        this.keyCertChainSupplier = Objects.requireNonNull(keyCertChainSupplier);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.keyPassword = Objects.requireNonNull(keyPassword);
    }

    public void clientAuth(ServerSecurityConfigurator.ClientAuth clientAuth) {
        this.clientAuth = Objects.requireNonNull(clientAuth);
    }

    public ReadOnlyServerSecurityConfig asReadOnly() {
        return new ReadOnlyServerSecurityConfig(this);
    }

    public ServerSslConfig asSslConfig() {
        ServerSslConfigBuilder builder;
        if (this.keyManagerFactory != null) {
            builder = new ServerSslConfigBuilder(this.keyManagerFactory);
        } else if (this.keyCertChainSupplier != null) {
            assert (this.keySupplier != null);
            builder = new ServerSslConfigBuilder(this.keyCertChainSupplier, this.keySupplier, this.keyPassword);
        } else {
            throw new IllegalStateException("required key material not set");
        }
        if (this.clientAuth == ServerSecurityConfigurator.ClientAuth.OPTIONAL) {
            builder.clientAuthMode(SslClientAuthMode.OPTIONAL);
        } else if (this.clientAuth == ServerSecurityConfigurator.ClientAuth.REQUIRE) {
            builder.clientAuthMode(SslClientAuthMode.REQUIRE);
        } else if (this.clientAuth == ServerSecurityConfigurator.ClientAuth.NONE) {
            builder.clientAuthMode(SslClientAuthMode.NONE);
        } else {
            throw new IllegalStateException("unsupported ClientAuth: " + (Object)((Object)this.clientAuth));
        }
        if (this.trustManagerFactory != null) {
            builder.trustManager(this.trustManagerFactory);
        } else if (this.trustCertChainSupplier != null) {
            builder.trustManager(this.trustCertChainSupplier);
        }
        if (this.protocols != null) {
            builder.sslProtocols(this.protocols);
        }
        if (this.ciphers != null) {
            builder.ciphers(this.ciphers);
        }
        builder.sessionCacheSize(this.sessionCacheSize);
        builder.sessionTimeout(this.sessionTimeout);
        if (this.provider == SecurityConfigurator.SslProvider.JDK) {
            builder.provider(SslProvider.JDK);
        } else if (this.provider == SecurityConfigurator.SslProvider.OPENSSL) {
            builder.provider(SslProvider.OPENSSL);
        }
        return builder.build();
    }
}

