/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.RequestResponseCloseHandler;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NonPipelinedCloseHandler
extends CloseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonPipelinedCloseHandler.class);
    private static final byte READ = 1;
    private static final byte WRITE = 2;
    private static final byte IN_CLOSED = 4;
    private static final byte OUT_CLOSED = 8;
    private static final byte CLOSED = 16;
    private static final byte GRACEFUL_CLOSE = 32;
    private static final byte IS_CLIENT = 64;
    private static final byte ALL_CLOSED = 28;
    private static final byte READ_WRITE = 3;
    private static final byte CLIENT_IN_WRITE = 70;
    private static final byte GRACEFUL_IN_CLOSED = 36;
    private static final byte GRACEFUL_OUT_CLOSED = 40;
    private byte state;
    private Consumer<CloseHandler.CloseEvent> eventHandler = __ -> {};
    @Nullable
    private CloseHandler.CloseEvent closeEvent;

    NonPipelinedCloseHandler(boolean isClient) {
        if (isClient) {
            this.state = (byte)64;
        }
    }

    @Override
    public void protocolPayloadBeginInbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)1);
    }

    @Override
    public void protocolPayloadEndInbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.unset(this.state, (byte)1);
        this.inboundEventCheckClose(ctx.channel(), this.closeEvent);
    }

    @Override
    public void protocolPayloadBeginOutbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)2);
    }

    @Override
    public void protocolPayloadEndOutbound(ChannelHandlerContext ctx, @Nullable ChannelPromise promise) {
        if (promise == null) {
            this.protocolPayloadEndOutbound0(ctx);
            return;
        }
        ctx.pipeline().fireUserEventTriggered(CloseHandler.OutboundDataEndEvent.INSTANCE);
        promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> this.protocolPayloadEndOutbound0(ctx)));
    }

    private void protocolPayloadEndOutbound0(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.unset(this.state, (byte)2);
        this.outboundEventCheckClose(ctx.channel(), this.closeEvent);
    }

    @Override
    public void protocolClosingInbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)4);
        CloseHandler.CloseEvent evt = CloseHandler.CloseEvent.PROTOCOL_CLOSING_INBOUND;
        this.storeCloseRequestAndEmit(evt);
        this.inboundEventCheckClose(ctx.channel(), evt);
    }

    @Override
    public void protocolClosingOutbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)8);
        CloseHandler.CloseEvent evt = CloseHandler.CloseEvent.PROTOCOL_CLOSING_OUTBOUND;
        this.storeCloseRequestAndEmit(evt);
        this.outboundEventCheckClose(ctx.channel(), evt);
    }

    @Override
    void registerEventHandler(Channel channel, Consumer<CloseHandler.CloseEvent> eventHandler) {
        this.eventHandler = Objects.requireNonNull(eventHandler);
    }

    @Override
    void channelClosedInbound(ChannelHandlerContext ctx) {
        if (!RequestResponseCloseHandler.State.has(this.state, (byte)4)) {
            this.state = NonPipelinedCloseHandler.unset(NonPipelinedCloseHandler.set(this.state, (byte)4), (byte)1);
            CloseHandler.CloseEvent evt = CloseHandler.CloseEvent.CHANNEL_CLOSED_INBOUND;
            this.storeCloseRequestAndEmit(evt);
            this.inboundEventCheckClose(ctx.channel(), evt);
        }
    }

    @Override
    void channelClosedOutbound(ChannelHandlerContext ctx) {
        if (!RequestResponseCloseHandler.State.has(this.state, (byte)8)) {
            this.state = NonPipelinedCloseHandler.unset(NonPipelinedCloseHandler.set(this.state, (byte)8), (byte)2);
            CloseHandler.CloseEvent evt = CloseHandler.CloseEvent.CHANNEL_CLOSED_OUTBOUND;
            this.storeCloseRequestAndEmit(evt);
            this.outboundEventCheckClose(ctx.channel(), evt);
        }
    }

    @Override
    void channelCloseNotify(ChannelHandlerContext ctx) {
        this.channelClosedInbound(ctx);
        this.closeChannelOutbound(ctx.channel());
    }

    @Override
    void closeChannelInbound(Channel channel) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)4);
        this.inboundEventCheckClose(channel, this.closeEvent);
    }

    @Override
    void closeChannelOutbound(Channel channel) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)8);
        this.outboundEventCheckClose(channel, this.closeEvent);
    }

    @Override
    void gracefulUserClosing(Channel channel) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)32);
        CloseHandler.CloseEvent evt = CloseHandler.CloseEvent.GRACEFUL_USER_CLOSING;
        this.storeCloseRequestAndEmit(evt);
        if (!NonPipelinedCloseHandler.isAnySet(this.state, (byte)3)) {
            this.closeChannel(channel, evt);
        }
    }

    private void inboundEventCheckClose(Channel channel, @Nullable CloseHandler.CloseEvent evt) {
        if (NonPipelinedCloseHandler.isAllSet(this.state, (byte)8) || NonPipelinedCloseHandler.isAnySet(this.state, (byte)36) && !NonPipelinedCloseHandler.isAllSet(this.state, (byte)2)) {
            this.closeChannel(channel, evt);
        } else if (NonPipelinedCloseHandler.isAllSet(this.state, (byte)70)) {
            this.state = NonPipelinedCloseHandler.unset(this.state, (byte)2);
            channel.pipeline().fireUserEventTriggered(CloseHandler.AbortWritesEvent.INSTANCE);
        }
    }

    private void outboundEventCheckClose(Channel channel, @Nullable CloseHandler.CloseEvent evt) {
        if (NonPipelinedCloseHandler.isAllSet(this.state, (byte)4) || NonPipelinedCloseHandler.isAnySet(this.state, (byte)40) && !NonPipelinedCloseHandler.isAllSet(this.state, (byte)1)) {
            this.closeChannel(channel, evt);
        }
    }

    private void storeCloseRequestAndEmit(CloseHandler.CloseEvent event) {
        if (this.closeEvent == null) {
            this.closeEvent = event;
        }
        this.eventHandler.accept(event);
    }

    private void closeChannel(Channel channel, @Nullable CloseHandler.CloseEvent evt) {
        if (!RequestResponseCloseHandler.State.has(this.state, (byte)16)) {
            this.state = NonPipelinedCloseHandler.set(this.state, (byte)28);
            LOGGER.trace("{} Closing channel \u2013 evt: {}", (Object)channel, (Object)evt);
            channel.close();
        }
    }

    private static byte set(byte state, byte flags) {
        return (byte)(state | flags);
    }

    private static byte unset(byte state, byte flags) {
        return (byte)(state & ~flags);
    }

    private static boolean isAllSet(byte state, byte flags) {
        return (state & flags) == flags;
    }

    private static boolean isAnySet(byte state, byte flags) {
        return (state & flags) != 0;
    }
}

