/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.IoThreadFactory;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutor;
import io.servicetalk.transport.netty.internal.EventLoopGroupIoExecutor;
import io.servicetalk.transport.netty.internal.EventLoopIoExecutor;
import io.servicetalk.transport.netty.internal.NativeTransportUtils;
import io.servicetalk.transport.netty.internal.NettyIoExecutor;
import io.servicetalk.transport.netty.internal.NettyIoThreadFactory;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyIoExecutors {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyIoExecutors.class);

    private NettyIoExecutors() {
    }

    public static EventLoopAwareNettyIoExecutor createIoExecutor() {
        return NettyIoExecutors.createIoExecutor(NettyIoExecutors.newIoThreadFactory());
    }

    public static EventLoopAwareNettyIoExecutor createIoExecutor(String threadNamePrefix) {
        return NettyIoExecutors.createIoExecutor(NettyIoExecutors.newIoThreadFactory(threadNamePrefix));
    }

    public static EventLoopAwareNettyIoExecutor createIoExecutor(int ioThreads) {
        return NettyIoExecutors.createIoExecutor(ioThreads, NettyIoExecutors.newIoThreadFactory());
    }

    public static EventLoopAwareNettyIoExecutor createIoExecutor(int ioThreads, String threadNamePrefix) {
        return NettyIoExecutors.createIoExecutor(ioThreads, NettyIoExecutors.newIoThreadFactory(threadNamePrefix));
    }

    public static <T extends Thread> EventLoopAwareNettyIoExecutor createIoExecutor(IoThreadFactory<T> threadFactory) {
        return NettyIoExecutors.createIoExecutor(Runtime.getRuntime().availableProcessors() * 2, threadFactory);
    }

    @Deprecated
    public static EventLoopAwareNettyIoExecutor createIoExecutor(ThreadFactory threadFactory) {
        return NettyIoExecutors.createIoExecutor(Runtime.getRuntime().availableProcessors() * 2, threadFactory);
    }

    public static <T extends Thread> EventLoopAwareNettyIoExecutor createIoExecutor(int ioThreads, IoThreadFactory<T> threadFactory) {
        NettyIoExecutors.validateIoThreads(ioThreads);
        return new EventLoopGroupIoExecutor(NettyIoExecutors.createEventLoopGroup(ioThreads, threadFactory), true);
    }

    @Deprecated
    public static EventLoopAwareNettyIoExecutor createIoExecutor(int ioThreads, ThreadFactory threadFactory) {
        NettyIoExecutors.validateIoThreads(ioThreads);
        return new EventLoopGroupIoExecutor(NettyIoExecutors.createEventLoopGroup(ioThreads, threadFactory), true);
    }

    private static <T extends Thread> EventLoopGroup createEventLoopGroup(int ioThreads, IoThreadFactory<T> threadFactory) {
        NettyIoExecutors.validateIoThreads(ioThreads);
        MultithreadEventLoopGroup group = NativeTransportUtils.isIoUringAvailable() ? new IOUringEventLoopGroup(ioThreads, threadFactory) : (NativeTransportUtils.isEpollAvailable() ? new EpollEventLoopGroup(ioThreads, threadFactory) : (NativeTransportUtils.isKQueueAvailable() ? new KQueueEventLoopGroup(ioThreads, threadFactory) : new NioEventLoopGroup(ioThreads, threadFactory)));
        LOGGER.debug("Created {} for {} threads using {}.", group.getClass().getSimpleName(), ioThreads, threadFactory);
        return group;
    }

    @Deprecated
    public static EventLoopGroup createEventLoopGroup(int ioThreads, ThreadFactory threadFactory) {
        NettyIoExecutors.validateIoThreads(ioThreads);
        return NativeTransportUtils.isEpollAvailable() ? new EpollEventLoopGroup(ioThreads, threadFactory) : (NativeTransportUtils.isKQueueAvailable() ? new KQueueEventLoopGroup(ioThreads, threadFactory) : new NioEventLoopGroup(ioThreads, threadFactory));
    }

    public static NettyIoExecutor toNettyIoExecutor(IoExecutor ioExecutor) {
        Objects.requireNonNull(ioExecutor);
        if (ioExecutor instanceof NettyIoExecutor) {
            return (NettyIoExecutor)ioExecutor;
        }
        throw new IllegalArgumentException("Incompatible IoExecutor: " + ioExecutor + ". Not a netty based IoExecutor.");
    }

    public static NettyIoExecutor fromNettyEventLoop(EventLoop eventLoop) {
        return new EventLoopIoExecutor(eventLoop, true);
    }

    public static NettyIoExecutor fromNettyEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return new EventLoopGroupIoExecutor(eventLoopGroup, true);
    }

    private static void validateIoThreads(int ioThreads) {
        if (ioThreads <= 0) {
            throw new IllegalArgumentException("ioThreads: " + ioThreads + " (expected >0)");
        }
    }

    private static NettyIoThreadFactory newIoThreadFactory() {
        return NettyIoExecutors.newIoThreadFactory(NettyIoExecutor.class.getSimpleName());
    }

    private static NettyIoThreadFactory newIoThreadFactory(String prefix) {
        return new NettyIoThreadFactory(prefix);
    }
}

