/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.EventLoopGroup;
import io.servicetalk.buffer.netty.BufferAllocators;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.concurrent.api.DelegatingExecutor;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.transport.api.DefaultExecutionContext;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutor;
import io.servicetalk.transport.netty.internal.NettyIoExecutors;
import io.servicetalk.transport.netty.internal.NettyIoThreadFactory;
import io.servicetalk.transport.netty.internal.OffloadAllExecutionStrategy;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalExecutionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExecutionContext.class);

    private GlobalExecutionContext() {
    }

    public static ExecutionContext globalExecutionContext() {
        return GlobalExecutionContextInitializer.INSTANCE;
    }

    private static void log(Logger logger, String name, String methodName) {
        logger.debug("Closure of \"{}\" was initiated using {} method. Closing the global instance before closing all resources that use it may result in unexpected behavior.", (Object)name, (Object)methodName);
    }

    private static final class GlobalExecutor
    extends DelegatingExecutor {
        private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExecutor.class);
        static final String NAME_PREFIX = "servicetalk-global-executor";

        GlobalExecutor(Executor delegate) {
            super(delegate);
        }

        @Override
        public Completable closeAsync() {
            return this.delegate().closeAsync().beforeOnSubscribe(__ -> GlobalExecutionContext.log(GlobalExecutor.LOGGER, NAME_PREFIX, "closeAsync()"));
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.delegate().closeAsyncGracefully().beforeOnSubscribe(__ -> GlobalExecutionContext.log(GlobalExecutor.LOGGER, NAME_PREFIX, "closeAsyncGracefully()"));
        }
    }

    private static final class GlobalIoExecutor
    implements EventLoopAwareNettyIoExecutor {
        private static final Logger LOGGER = LoggerFactory.getLogger(GlobalIoExecutor.class);
        static final String NAME_PREFIX = "servicetalk-global-io-executor";
        private final EventLoopAwareNettyIoExecutor delegate;

        GlobalIoExecutor(EventLoopAwareNettyIoExecutor delegate) {
            this.delegate = delegate;
        }

        @Override
        public Completable closeAsync() {
            return this.delegate.closeAsync().beforeOnSubscribe(__ -> GlobalExecutionContext.log(GlobalIoExecutor.LOGGER, NAME_PREFIX, "closeAsync()"));
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.delegate.closeAsyncGracefully().beforeOnSubscribe(__ -> GlobalExecutionContext.log(GlobalIoExecutor.LOGGER, NAME_PREFIX, "closeAsyncGracefully()"));
        }

        @Override
        public Completable onClose() {
            return this.delegate.onClose();
        }

        @Override
        public boolean isUnixDomainSocketSupported() {
            return this.delegate.isUnixDomainSocketSupported();
        }

        @Override
        public boolean isFileDescriptorSocketAddressSupported() {
            return this.delegate.isFileDescriptorSocketAddressSupported();
        }

        @Override
        public boolean isCurrentThreadEventLoop() {
            return this.delegate.isCurrentThreadEventLoop();
        }

        @Override
        public EventLoopGroup eventLoopGroup() {
            return this.delegate.eventLoopGroup();
        }

        @Override
        public EventLoopAwareNettyIoExecutor next() {
            return this.delegate.next();
        }

        @Override
        @Deprecated
        public Executor asExecutor() {
            return this.delegate.asExecutor();
        }

        @Override
        public Cancellable execute(Runnable task) throws RejectedExecutionException {
            return this.delegate.execute(task);
        }

        @Override
        public Cancellable schedule(Runnable task, long delay, TimeUnit unit) throws RejectedExecutionException {
            return this.delegate.schedule(task, delay, unit);
        }
    }

    private static final class GlobalExecutionContextInitializer {
        static final ExecutionContext INSTANCE;

        private GlobalExecutionContextInitializer() {
        }

        static {
            GlobalIoExecutor ioExecutor = new GlobalIoExecutor(NettyIoExecutors.createIoExecutor(new NettyIoThreadFactory("servicetalk-global-io-executor", true)));
            GlobalExecutor executor = new GlobalExecutor(Executors.newCachedThreadExecutor(new DefaultThreadFactory("servicetalk-global-executor", true, 5)));
            INSTANCE = new DefaultExecutionContext(BufferAllocators.DEFAULT_ALLOCATOR, ioExecutor, executor, OffloadAllExecutionStrategy.OFFLOAD_ALL_STRATEGY);
            LOGGER.debug("Initialized GlobalExecutionContext");
        }
    }
}

