/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ClientSslConfigBuilder;
import io.servicetalk.transport.api.SecurityConfigurator;
import io.servicetalk.transport.api.SslProvider;
import io.servicetalk.transport.netty.internal.ReadOnlyClientSecurityConfig;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

@Deprecated
public class ClientSecurityConfig
extends ReadOnlyClientSecurityConfig {
    public void hostNameVerificationAlgorithm(String hostNameVerificationAlgorithm) {
        this.hostnameVerificationAlgorithm = Objects.requireNonNull(hostNameVerificationAlgorithm);
    }

    public void hostNameVerification(String hostNameVerificationAlgorithm, String hostNameVerificationHost) {
        this.hostnameVerificationAlgorithm = Objects.requireNonNull(hostNameVerificationAlgorithm);
        this.hostNameVerificationHost = hostNameVerificationHost;
    }

    public void hostNameVerification(String hostNameVerificationAlgorithm, String hostNameVerificationHost, int hostNameVerificationPort) {
        this.hostnameVerificationAlgorithm = Objects.requireNonNull(hostNameVerificationAlgorithm);
        this.hostNameVerificationHost = hostNameVerificationHost;
        this.hostNameVerificationPort = hostNameVerificationPort;
    }

    public void hostNameVerification(String hostNameVerificationHost) {
        this.hostNameVerificationHost = hostNameVerificationHost;
    }

    public void hostNameVerification(String hostNameVerificationHost, int hostNameVerificationPort) {
        this.hostNameVerificationHost = hostNameVerificationHost;
        this.hostNameVerificationPort = hostNameVerificationPort;
    }

    public void sniHostname(String sniHostname) {
        this.sniHostname = Objects.requireNonNull(sniHostname);
    }

    public void disableHostnameVerification() {
        this.hostnameVerificationAlgorithm = null;
        this.hostNameVerificationHost = null;
        this.hostNameVerificationPort = -1;
    }

    public void trustManager(Supplier<InputStream> trustCertChainSupplier) {
        this.trustCertChainSupplier = Objects.requireNonNull(trustCertChainSupplier);
    }

    public void trustManager(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = Objects.requireNonNull(trustManagerFactory);
    }

    public void protocols(String ... protocols) {
        this.protocols = Arrays.asList(protocols);
    }

    public void ciphers(Iterable<String> ciphers) {
        this.ciphers = ClientSecurityConfig.toList(ciphers);
    }

    static <T> List<T> toList(Iterable<T> ciphers) {
        ArrayList list;
        if (ciphers instanceof List) {
            list = (ArrayList)ciphers;
        } else {
            list = new ArrayList();
            ciphers.forEach(list::add);
        }
        return list;
    }

    public void sessionCacheSize(long sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
    }

    public void sessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void provider(SecurityConfigurator.SslProvider provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    public void keyManager(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = Objects.requireNonNull(keyManagerFactory);
    }

    public void keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier) {
        this.keyCertChainSupplier = Objects.requireNonNull(keyCertChainSupplier);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.keyPassword = null;
    }

    public void keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier, String keyPassword) {
        this.keyCertChainSupplier = Objects.requireNonNull(keyCertChainSupplier);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.keyPassword = Objects.requireNonNull(keyPassword);
    }

    public ReadOnlyClientSecurityConfig asReadOnly() {
        return new ReadOnlyClientSecurityConfig(this);
    }

    public ClientSslConfig asSslConfig() {
        ClientSslConfigBuilder builder = this.trustManagerFactory != null ? new ClientSslConfigBuilder(this.trustManagerFactory) : (this.trustCertChainSupplier != null ? new ClientSslConfigBuilder(this.trustCertChainSupplier) : new ClientSslConfigBuilder());
        if (this.hostnameVerificationAlgorithm == null) {
            builder.hostnameVerificationAlgorithm("");
        } else {
            builder.hostnameVerificationAlgorithm(this.hostnameVerificationAlgorithm);
        }
        if (this.hostNameVerificationHost != null) {
            builder.peerHost(this.hostNameVerificationHost);
            builder.peerPort(this.hostNameVerificationPort);
        }
        if (this.sniHostname != null) {
            builder.sniHostname(this.sniHostname);
        }
        if (this.keyManagerFactory != null) {
            builder.keyManager(this.keyManagerFactory);
        } else if (this.keyCertChainSupplier != null) {
            assert (this.keySupplier != null);
            builder.keyManager(this.keyCertChainSupplier, this.keySupplier, this.keyPassword);
        }
        if (this.protocols != null) {
            builder.sslProtocols(this.protocols);
        }
        if (this.ciphers != null) {
            builder.ciphers(this.ciphers);
        }
        builder.sessionCacheSize(this.sessionCacheSize);
        builder.sessionTimeout(this.sessionTimeout);
        if (this.provider == SecurityConfigurator.SslProvider.JDK) {
            builder.provider(SslProvider.JDK);
        } else if (this.provider == SecurityConfigurator.SslProvider.OPENSSL) {
            builder.provider(SslProvider.OPENSSL);
        }
        return builder.build();
    }
}

