/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.incubator.channel.uring.IOUringDatagramChannel;
import io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import io.netty.util.NetUtil;
import io.servicetalk.transport.api.FileDescriptorSocketAddress;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.netty.internal.NativeTransportUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import javax.annotation.Nullable;

public final class BuilderUtils {
    private BuilderUtils() {
    }

    @Deprecated
    public static boolean useEpoll(EventLoopGroup group) {
        return NativeTransportUtils.useEpoll(group);
    }

    @Deprecated
    public static boolean useKQueue(EventLoopGroup group) {
        return NativeTransportUtils.useKQueue(group);
    }

    public static Class<? extends ServerChannel> serverChannel(EventLoopGroup group, Class<? extends SocketAddress> addressClass) {
        if (NativeTransportUtils.useIoUring(group)) {
            return IOUringServerSocketChannel.class;
        }
        if (BuilderUtils.useEpoll(group)) {
            return DomainSocketAddress.class.isAssignableFrom(addressClass) ? EpollServerDomainSocketChannel.class : EpollServerSocketChannel.class;
        }
        if (BuilderUtils.useKQueue(group)) {
            return DomainSocketAddress.class.isAssignableFrom(addressClass) ? KQueueServerDomainSocketChannel.class : KQueueServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends Channel> socketChannel(EventLoopGroup group, Class<? extends SocketAddress> addressClass) {
        if (NativeTransportUtils.useIoUring(group)) {
            if (DomainSocketAddress.class.isAssignableFrom(addressClass)) {
                throw new IllegalArgumentException("io_uring does not support DomainSocketAddress");
            }
            return IOUringSocketChannel.class;
        }
        if (BuilderUtils.useEpoll(group)) {
            return DomainSocketAddress.class.isAssignableFrom(addressClass) ? EpollDomainSocketChannel.class : EpollSocketChannel.class;
        }
        if (BuilderUtils.useKQueue(group)) {
            return DomainSocketAddress.class.isAssignableFrom(addressClass) ? KQueueDomainSocketChannel.class : KQueueSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    @Nullable
    public static Channel socketChannel(EventLoopGroup group, FileDescriptorSocketAddress address) {
        if (NativeTransportUtils.useIoUring(group)) {
            throw new IllegalArgumentException("io_uring does not support FileDescriptorSocketAddress");
        }
        if (BuilderUtils.useEpoll(group)) {
            return new EpollSocketChannel(address.getValue());
        }
        if (BuilderUtils.useKQueue(group)) {
            return new KQueueSocketChannel(address.getValue());
        }
        return null;
    }

    public static SocketAddress toNettyAddress(Object address) {
        if (address instanceof io.servicetalk.transport.api.DomainSocketAddress) {
            return new DomainSocketAddress(((io.servicetalk.transport.api.DomainSocketAddress)address).getPath());
        }
        if (address instanceof SocketAddress) {
            return (SocketAddress)address;
        }
        if (address instanceof HostAndPort) {
            return BuilderUtils.toResolvedInetSocketAddress((HostAndPort)address);
        }
        throw new IllegalArgumentException("Unsupported address: " + address);
    }

    public static InetSocketAddress toResolvedInetSocketAddress(HostAndPort resolvedAddress) {
        try {
            return new InetSocketAddress(InetAddress.getByAddress(NetUtil.createByteArrayFromIpAddressString(resolvedAddress.hostName())), resolvedAddress.port());
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid resolved address: " + resolvedAddress.hostName() + ", expected IP-address.", e);
        }
    }

    public static Class<? extends DatagramChannel> datagramChannel(EventLoopGroup group) {
        if (NativeTransportUtils.useIoUring(group)) {
            return IOUringDatagramChannel.class;
        }
        if (BuilderUtils.useEpoll(group)) {
            return EpollDatagramChannel.class;
        }
        if (BuilderUtils.useKQueue(group)) {
            return KQueueDatagramChannel.class;
        }
        return NioDatagramChannel.class;
    }

    public static String formatCanonicalAddress(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (inetAddress == null) {
                return address.toString();
            }
            if (inetAddress instanceof Inet6Address) {
                return '[' + NetUtil.toAddressString(inetAddress) + "]:" + inetSocketAddress.getPort();
            }
            return NetUtil.toAddressString(inetAddress) + ':' + inetSocketAddress.getPort();
        }
        return address.toString();
    }

    public static void closeAndRethrowUnchecked(@Nullable Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(closable + " must be closed, but threw unexpectedly", e);
            }
        }
    }
}

