/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.transport.api.ConnectionInfo;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.api.TransportObservers;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;

final class BiTransportObserver
implements TransportObserver {
    private final TransportObserver first;
    private final TransportObserver second;

    BiTransportObserver(TransportObserver first, TransportObserver second) {
        this.first = TransportObservers.asSafeObserver(first);
        this.second = TransportObservers.asSafeObserver(second);
    }

    @Override
    public ConnectionObserver onNewConnection() {
        return new BiConnectionObserver(this.first.onNewConnection(), this.second.onNewConnection());
    }

    @Override
    public ConnectionObserver onNewConnection(@Nullable Object localAddress, Object remoteAddress) {
        return new BiConnectionObserver(this.first.onNewConnection(localAddress, remoteAddress), this.second.onNewConnection(localAddress, remoteAddress));
    }

    private static final class BiWriteObserver
    implements ConnectionObserver.WriteObserver {
        private final ConnectionObserver.WriteObserver first;
        private final ConnectionObserver.WriteObserver second;

        private BiWriteObserver(ConnectionObserver.WriteObserver first, ConnectionObserver.WriteObserver second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void requestedToWrite(long n) {
            this.first.requestedToWrite(n);
            this.second.requestedToWrite(n);
        }

        @Override
        public void itemReceived() {
            this.first.itemReceived();
            this.second.itemReceived();
        }

        @Override
        public void itemReceived(@Nullable Object item) {
            this.first.itemReceived(item);
            this.second.itemReceived(item);
        }

        @Override
        public void onFlushRequest() {
            this.first.onFlushRequest();
            this.second.onFlushRequest();
        }

        @Override
        public void itemWritten() {
            this.first.itemWritten();
            this.second.itemWritten();
        }

        @Override
        public void itemWritten(@Nullable Object item) {
            this.first.itemWritten(item);
            this.second.itemWritten(item);
        }

        @Override
        public void itemFlushed() {
            this.first.itemFlushed();
            this.second.itemFlushed();
        }

        @Override
        public void writeFailed(Throwable cause) {
            this.first.writeFailed(cause);
            this.second.writeFailed(cause);
        }

        @Override
        public void writeComplete() {
            this.first.writeComplete();
            this.second.writeComplete();
        }

        @Override
        public void writeCancelled() {
            this.first.writeCancelled();
            this.second.writeCancelled();
        }
    }

    private static final class BiReadObserver
    implements ConnectionObserver.ReadObserver {
        private final ConnectionObserver.ReadObserver first;
        private final ConnectionObserver.ReadObserver second;

        private BiReadObserver(ConnectionObserver.ReadObserver first, ConnectionObserver.ReadObserver second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void requestedToRead(long n) {
            this.first.requestedToRead(n);
            this.second.requestedToRead(n);
        }

        @Override
        public void itemRead() {
            this.first.itemRead();
            this.second.itemRead();
        }

        @Override
        public void itemRead(@Nullable Object item) {
            this.first.itemRead(item);
            this.second.itemRead(item);
        }

        @Override
        public void readFailed(Throwable cause) {
            this.first.readFailed(cause);
            this.second.readFailed(cause);
        }

        @Override
        public void readComplete() {
            this.first.readComplete();
            this.second.readComplete();
        }

        @Override
        public void readCancelled() {
            this.first.readCancelled();
            this.second.readCancelled();
        }
    }

    private static final class BiStreamObserver
    implements ConnectionObserver.StreamObserver {
        private final ConnectionObserver.StreamObserver first;
        private final ConnectionObserver.StreamObserver second;

        private BiStreamObserver(ConnectionObserver.StreamObserver first, ConnectionObserver.StreamObserver second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void streamIdAssigned(long streamId) {
            this.first.streamIdAssigned(streamId);
            this.second.streamIdAssigned(streamId);
        }

        @Override
        public ConnectionObserver.DataObserver streamEstablished() {
            return new BiDataObserver(this.first.streamEstablished(), this.second.streamEstablished());
        }

        @Override
        public void streamClosed(Throwable error) {
            this.first.streamClosed(error);
            this.second.streamClosed(error);
        }

        @Override
        public void streamClosed() {
            this.first.streamClosed();
            this.second.streamClosed();
        }
    }

    private static final class BiMultiplexedObserver
    implements ConnectionObserver.MultiplexedObserver {
        private final ConnectionObserver.MultiplexedObserver first;
        private final ConnectionObserver.MultiplexedObserver second;

        private BiMultiplexedObserver(ConnectionObserver.MultiplexedObserver first, ConnectionObserver.MultiplexedObserver second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public ConnectionObserver.StreamObserver onNewStream() {
            return new BiStreamObserver(this.first.onNewStream(), this.second.onNewStream());
        }
    }

    private static final class BiDataObserver
    implements ConnectionObserver.DataObserver {
        private final ConnectionObserver.DataObserver first;
        private final ConnectionObserver.DataObserver second;

        private BiDataObserver(ConnectionObserver.DataObserver first, ConnectionObserver.DataObserver second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public ConnectionObserver.ReadObserver onNewRead() {
            return new BiReadObserver(this.first.onNewRead(), this.second.onNewRead());
        }

        @Override
        public ConnectionObserver.WriteObserver onNewWrite() {
            return new BiWriteObserver(this.first.onNewWrite(), this.second.onNewWrite());
        }
    }

    private static final class BiSecurityHandshakeObserver
    implements ConnectionObserver.SecurityHandshakeObserver {
        private final ConnectionObserver.SecurityHandshakeObserver first;
        private final ConnectionObserver.SecurityHandshakeObserver second;

        private BiSecurityHandshakeObserver(ConnectionObserver.SecurityHandshakeObserver first, ConnectionObserver.SecurityHandshakeObserver second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void handshakeFailed(Throwable cause) {
            this.first.handshakeFailed(cause);
            this.second.handshakeFailed(cause);
        }

        @Override
        public void handshakeComplete(SSLSession sslSession) {
            this.first.handshakeComplete(sslSession);
            this.second.handshakeComplete(sslSession);
        }
    }

    private static final class BiConnectionObserver
    implements ConnectionObserver {
        private final ConnectionObserver first;
        private final ConnectionObserver second;

        private BiConnectionObserver(ConnectionObserver first, ConnectionObserver second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void onDataRead(int size) {
            this.first.onDataRead(size);
            this.second.onDataRead(size);
        }

        @Override
        public void onDataWrite(int size) {
            this.first.onDataWrite(size);
            this.second.onDataWrite(size);
        }

        @Override
        public void onFlush() {
            this.first.onFlush();
            this.second.onFlush();
        }

        @Override
        public void onTransportHandshakeComplete() {
            this.first.onTransportHandshakeComplete();
            this.second.onTransportHandshakeComplete();
        }

        @Override
        public ConnectionObserver.SecurityHandshakeObserver onSecurityHandshake() {
            return new BiSecurityHandshakeObserver(this.first.onSecurityHandshake(), this.second.onSecurityHandshake());
        }

        @Override
        public ConnectionObserver.DataObserver connectionEstablished(ConnectionInfo info) {
            return new BiDataObserver(this.first.connectionEstablished(info), this.second.connectionEstablished(info));
        }

        @Override
        public ConnectionObserver.MultiplexedObserver multiplexedConnectionEstablished(ConnectionInfo info) {
            return new BiMultiplexedObserver(this.first.multiplexedConnectionEstablished(info), this.second.multiplexedConnectionEstablished(info));
        }

        @Override
        public void connectionClosed(Throwable error) {
            this.first.connectionClosed(error);
            this.second.connectionClosed(error);
        }

        @Override
        public void connectionClosed() {
            this.first.connectionClosed();
            this.second.connectionClosed();
        }
    }
}

