/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancer;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class RoundRobinLoadBalancerFactory<ResolvedAddress, C extends LoadBalancedConnection>
implements LoadBalancerFactory<ResolvedAddress, C> {
    @Nullable
    static final Boolean EAGER_CONNECTION_SHUTDOWN_ENABLED = null;
    static final Duration DEFAULT_HEALTH_CHECK_INTERVAL = Duration.ofSeconds(1L);
    static final int DEFAULT_HEALTH_CHECK_FAILED_CONNECTIONS_THRESHOLD = 5;
    @Nullable
    private final Boolean eagerConnectionShutdown;
    @Nullable
    private final RoundRobinLoadBalancer.HealthCheckConfig healthCheckConfig;

    private RoundRobinLoadBalancerFactory(@Nullable Boolean eagerConnectionShutdown, @Nullable RoundRobinLoadBalancer.HealthCheckConfig healthCheckConfig) {
        this.eagerConnectionShutdown = eagerConnectionShutdown;
        this.healthCheckConfig = healthCheckConfig;
    }

    @Override
    public <T extends C> LoadBalancer<T> newLoadBalancer(Publisher<? extends ServiceDiscovererEvent<ResolvedAddress>> eventPublisher, ConnectionFactory<ResolvedAddress, T> connectionFactory) {
        return new RoundRobinLoadBalancer<ResolvedAddress, T>(eventPublisher, connectionFactory, this.eagerConnectionShutdown, this.healthCheckConfig);
    }

    @Override
    public <T extends C> LoadBalancer<T> newLoadBalancer(String targetResource, Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, T> connectionFactory) {
        return new RoundRobinLoadBalancer<ResolvedAddress, T>(Objects.requireNonNull(targetResource), eventPublisher, connectionFactory, this.eagerConnectionShutdown, this.healthCheckConfig);
    }

    static final class SharedExecutor {
        private static final Executor INSTANCE = Executors.from(new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory("round-robin-load-balancer-executor")));

        private SharedExecutor() {
        }

        static Executor getInstance() {
            return INSTANCE;
        }
    }

    public static final class Builder<ResolvedAddress, C extends LoadBalancedConnection> {
        @Nullable
        private Boolean eagerConnectionShutdown = EAGER_CONNECTION_SHUTDOWN_ENABLED;
        @Nullable
        private Executor backgroundExecutor;
        private Duration healthCheckInterval = DEFAULT_HEALTH_CHECK_INTERVAL;
        private int healthCheckFailedConnectionsThreshold = 5;

        @Deprecated
        public Builder<ResolvedAddress, C> eagerConnectionShutdown(boolean eagerConnectionShutdown) {
            this.eagerConnectionShutdown = eagerConnectionShutdown;
            return this;
        }

        public Builder<ResolvedAddress, C> backgroundExecutor(Executor backgroundExecutor) {
            this.backgroundExecutor = Objects.requireNonNull(backgroundExecutor);
            return this;
        }

        public Builder<ResolvedAddress, C> healthCheckInterval(Duration interval) {
            if (interval.isNegative() || interval.isZero()) {
                throw new IllegalArgumentException("Health check interval should be greater than 0");
            }
            this.healthCheckInterval = interval;
            return this;
        }

        public Builder<ResolvedAddress, C> healthCheckFailedConnectionsThreshold(int threshold) {
            if (threshold == 0) {
                throw new IllegalArgumentException("Health check failed connections threshold should not be 0");
            }
            this.healthCheckFailedConnectionsThreshold = threshold;
            return this;
        }

        public RoundRobinLoadBalancerFactory<ResolvedAddress, C> build() {
            if (this.healthCheckFailedConnectionsThreshold < 0) {
                return new RoundRobinLoadBalancerFactory(this.eagerConnectionShutdown, null);
            }
            RoundRobinLoadBalancer.HealthCheckConfig healthCheckConfig = new RoundRobinLoadBalancer.HealthCheckConfig(this.backgroundExecutor == null ? SharedExecutor.getInstance() : this.backgroundExecutor, this.healthCheckInterval, this.healthCheckFailedConnectionsThreshold);
            return new RoundRobinLoadBalancerFactory(this.eagerConnectionShutdown, healthCheckConfig);
        }
    }
}

