/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.utils.AbstractTimeoutHttpFilter;
import io.servicetalk.http.utils.TimeoutFromRequest;
import java.time.Duration;

public final class TimeoutHttpServiceFilter
extends AbstractTimeoutHttpFilter
implements StreamingHttpServiceFilterFactory {
    public TimeoutHttpServiceFilter(Duration duration) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration), false);
    }

    public TimeoutHttpServiceFilter(Duration duration, Executor timeoutExecutor) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration), false, timeoutExecutor);
    }

    public TimeoutHttpServiceFilter(Duration duration, boolean fullRequestResponse) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration), fullRequestResponse);
    }

    public TimeoutHttpServiceFilter(Duration duration, boolean fullRequestResponse, Executor timeoutExecutor) {
        this(new AbstractTimeoutHttpFilter.FixedDuration(duration), fullRequestResponse, timeoutExecutor);
    }

    public TimeoutHttpServiceFilter(TimeoutFromRequest timeoutForRequest, boolean fullRequestResponse) {
        super(timeoutForRequest, fullRequestResponse);
    }

    public TimeoutHttpServiceFilter(TimeoutFromRequest timeoutForRequest, boolean fullRequestResponse, Executor timeoutExecutor) {
        super(timeoutForRequest, fullRequestResponse, timeoutExecutor);
    }

    @Override
    public StreamingHttpServiceFilter create(StreamingHttpService service) {
        return new StreamingHttpServiceFilter(service){

            @Override
            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                HttpExecutionContext executionContext = ctx.executionContext();
                return TimeoutHttpServiceFilter.this.withTimeout(request, r -> this.delegate().handle(ctx, (StreamingHttpRequest)r, responseFactory), executionContext.executionStrategy().hasOffloads() ? executionContext.executor() : executionContext.ioExecutor());
            }
        };
    }
}

